/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest;

import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidParameterException;

public abstract class DataRequest {
    public static final int MIN_OFFSET_VALUE = 0;
    public static final int MAX_OFFSET_VALUE = Integer.MAX_VALUE;
    public static final byte BUFFER_LENGTH_BYTE = 1;
    public static final byte BUFFER_LENGTH_SHORT = 2;
    public static final byte BUFFER_LENGTH_INT = 4;
    public static final byte BUFFER_LENGTH_LONG = 8;
    public static final byte BUFFER_LENGTH_FLOAT = 4;
    public static final byte BUFFER_LENGTH_DOUBLE = 8;
    protected byte[] dataBuffer;
    protected int offset = 26304;
    protected IDataRequest.RequestType type = IDataRequest.RequestType.READ;

    public byte[] getDataBuffer() {
        return this.dataBuffer;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        if (this.dataBuffer != null) {
            return this.dataBuffer.length;
        }
        return -1;
    }

    public void setOffset(int offset) throws InvalidParameterException {
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public IDataRequest.RequestType getType() {
        return this.type;
    }

    public void setType(IDataRequest.RequestType type) {
        this.type = type;
    }

    protected final short getShort() {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(this.dataBuffer, 0, 2);
        return buf.getShort(0);
    }

    protected final int getInt() {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(this.dataBuffer, 0, 4);
        return buf.getInt(0);
    }

    protected final long getLong() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(this.dataBuffer, 0, 8);
        return buf.getLong(0);
    }

    protected final float getFloat() {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(this.dataBuffer, 0, 4);
        return buf.getFloat(0);
    }

    protected final double getDouble() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(this.dataBuffer, 0, 8);
        return buf.getDouble(0);
    }

    protected final void putShort(Short value) {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putInt(Integer value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putLong(Long value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putFloat(Float value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putFloat(value.floatValue());
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putDouble(Double value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putDouble(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putShort(short value) {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putInt(int value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putLong(long value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putFloat(float value) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putFloat(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }

    protected final void putDouble(double value) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putDouble(value);
        buf.rewind();
        buf.get(this.dataBuffer);
    }
}

