/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.security.InvalidParameterException;

public class ByteArrayRequest
extends DataRequest
implements IDataRequest<byte[]> {
    public ByteArrayRequest(int size) {
        this.dataBuffer = new byte[size];
    }

    public ByteArrayRequest(int offset, int size) throws InvalidParameterException {
        this(size);
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public ByteArrayRequest(int offset, byte[] data) throws InvalidParameterException {
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.copyByteArray(data);
        this.type = IDataRequest.RequestType.WRITE;
    }

    @Override
    public byte[] getValue() {
        return this.dataBuffer;
    }

    @Override
    public void setValue(byte[] value) {
        this.copyByteArray(value);
    }
}

