/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers.avionics;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IReadOnlyRequest;
import com.mouseviator.fsuipc.datarequest.primitives.ShortRequest;
import com.mouseviator.fsuipc.helpers.avionics.RadioHelper;
import java.security.InvalidParameterException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public abstract class NavRadioHelper
extends RadioHelper {
    protected int CDINeedleOffset;
    protected int localiserNeedleOffset;
    protected int GSINeedleOffset;
    protected int signalStrengthOffset;
    protected int radialOffset;
    protected int OBSSettingOffset;
    protected int VORrelativeBearingOffset;
    protected int ToFromFlagOffset;
    protected int backCourseFlagOffset;
    protected int codeFlagsOffset;
    protected int GSFlagOffset;
    protected int MagVarOffset;
    protected int latitudeOffset1;
    protected int latitudeOffset2;
    protected int longitudeOffset1;
    protected int longitudeOffset2;
    protected int elevationOffset1;
    protected int elevationOffset2;
    protected int ilsGlideSlopeInclinationOffset;
    protected int ilsInverseRunwayHeadingOffset;
    protected int nameOffset;
    protected int identityOffset;
    protected int dmeDistanceOffset;
    protected int dmeSpeedOffset;
    protected int dmeTimeToStationOffset;

    public IDataRequest<Float> getCDINeedle() {
        class CDINeedleRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            CDINeedleRequest() {
                this.offset = NavRadioHelper.this.CDINeedleOffset;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Float getValue() {
                return Float.valueOf(this.getFloat());
            }
        }
        return new CDINeedleRequest();
    }

    public IDataRequest<Float> getGSINeedle() {
        class GSINeedleRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            GSINeedleRequest() {
                this.offset = NavRadioHelper.this.GSINeedleOffset;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Float getValue() {
                return Float.valueOf(this.getFloat());
            }
        }
        return new GSINeedleRequest();
    }

    public IDataRequest<Byte> getLocaliserNeedle() {
        class LocaliserNeedleRequest
        extends DataRequest
        implements IReadOnlyRequest<Byte> {
            LocaliserNeedleRequest() {
                this.offset = NavRadioHelper.this.localiserNeedleOffset;
                this.dataBuffer = new byte[1];
            }

            @Override
            public Byte getValue() {
                return this.dataBuffer[0];
            }
        }
        return new LocaliserNeedleRequest();
    }

    public IDataRequest<Integer> getSignalStrength() {
        class SignalStrengthRequest
        extends DataRequest
        implements IReadOnlyRequest<Integer> {
            SignalStrengthRequest() {
                this.offset = NavRadioHelper.this.signalStrengthOffset;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Integer getValue() {
                return this.getInt();
            }
        }
        return new SignalStrengthRequest();
    }

    public IDataRequest<Float> getRadial(boolean bDegrees) {
        if (bDegrees) {
            class RadialRequest
            extends DataRequest
            implements IReadOnlyRequest<Float> {
                RadialRequest() {
                    this.offset = NavRadioHelper.this.radialOffset;
                    this.dataBuffer = new byte[2];
                }

                @Override
                public Float getValue() {
                    short value = this.getShort();
                    float radial = (float)(value * 360) / 65536.0f;
                    return Float.valueOf(radial);
                }
            }
            return new RadialRequest();
        }
        class RadialRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            RadialRequest() {
                this.offset = NavRadioHelper.this.radialOffset;
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short value = this.getShort();
                float radial = (float)(value * 360) / 65536.0f;
                return Float.valueOf((float)Math.toRadians(radial));
            }
        }
        return new RadialRequest();
    }

    public ShortRequest getOBSSettings() {
        return new ShortRequest(this.OBSSettingOffset);
    }

    public IDataRequest<Short> getVORRelativeBearing() {
        class VORRelativeBearingRequest
        extends DataRequest
        implements IReadOnlyRequest<Short> {
            VORRelativeBearingRequest() {
                this.offset = NavRadioHelper.this.VORrelativeBearingOffset;
                this.dataBuffer = new byte[2];
            }

            @Override
            public Short getValue() {
                return this.getShort();
            }
        }
        return new VORRelativeBearingRequest();
    }

    public IDataRequest<Byte> getToFromFlag() {
        class ToFromFlagRequest
        extends DataRequest
        implements IReadOnlyRequest<Byte> {
            ToFromFlagRequest() {
                this.offset = NavRadioHelper.this.ToFromFlagOffset;
                this.dataBuffer = new byte[1];
            }

            @Override
            public Byte getValue() {
                return this.dataBuffer[0];
            }
        }
        return new ToFromFlagRequest();
    }

    public IDataRequest<Byte> getGSFlag() {
        class GSFlagRequest
        extends DataRequest
        implements IReadOnlyRequest<Byte> {
            GSFlagRequest() {
                this.offset = NavRadioHelper.this.GSFlagOffset;
                this.dataBuffer = new byte[1];
            }

            @Override
            public Byte getValue() {
                return this.dataBuffer[0];
            }
        }
        return new GSFlagRequest();
    }

    public IDataRequest<Byte> getBackCourseFlags() {
        class BackCourseFlagsRequest
        extends DataRequest
        implements IReadOnlyRequest<Byte> {
            BackCourseFlagsRequest() {
                this.offset = NavRadioHelper.this.backCourseFlagOffset;
                this.dataBuffer = new byte[1];
            }

            @Override
            public Byte getValue() {
                return this.dataBuffer[0];
            }
        }
        return new BackCourseFlagsRequest();
    }

    public IDataRequest<Float> getMagneticVariation(boolean bDegrees) {
        if (bDegrees) {
            class MagVarRequest
            extends DataRequest
            implements IReadOnlyRequest<Float> {
                MagVarRequest() {
                    this.offset = NavRadioHelper.this.MagVarOffset;
                    this.dataBuffer = new byte[2];
                }

                @Override
                public Float getValue() {
                    short value = this.getShort();
                    float magVar = (float)(value * 360) / 65536.0f;
                    return Float.valueOf(magVar);
                }
            }
            return new MagVarRequest();
        }
        class MagVarRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            MagVarRequest() {
                this.offset = NavRadioHelper.this.MagVarOffset;
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short value = this.getShort();
                float magVar = (float)(value * 360) / 65536.0f;
                return Float.valueOf((float)Math.toRadians(magVar));
            }
        }
        return new MagVarRequest();
    }

    public IDataRequest<Byte> getCodeFlags() {
        class CodeFlagsRequest
        extends DataRequest
        implements IReadOnlyRequest<Byte> {
            CodeFlagsRequest() {
                this.offset = NavRadioHelper.this.codeFlagsOffset;
                this.dataBuffer = new byte[1];
            }

            @Override
            public Byte getValue() {
                return this.dataBuffer[0];
            }
        }
        return new CodeFlagsRequest();
    }

    public IDataRequest<Double> getLatitude1() {
        class LatitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LatitudeRequest() {
                this.offset = NavRadioHelper.this.latitudeOffset1;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Double getValue() {
                int value = this.getInt();
                double latitude = (double)value * 90.0 / 1.000175E7;
                return latitude;
            }
        }
        return new LatitudeRequest();
    }

    public IDataRequest<Double> getLatitude2() {
        class LatitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LatitudeRequest() {
                this.offset = NavRadioHelper.this.latitudeOffset2;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Double getValue() {
                int value = this.getInt();
                double latitude = (double)value * 90.0 / 1.000175E7;
                return latitude;
            }
        }
        return new LatitudeRequest();
    }

    public IDataRequest<Double> getLongitude1() {
        class LongitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LongitudeRequest() {
                this.offset = NavRadioHelper.this.longitudeOffset1;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Double getValue() {
                int value = this.getInt();
                double longitude = (double)value * 360.0 / 4.294967296E9;
                return longitude;
            }
        }
        return new LongitudeRequest();
    }

    public IDataRequest<Double> getLongitude2() {
        class LongitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            LongitudeRequest() {
                this.offset = NavRadioHelper.this.longitudeOffset2;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Double getValue() {
                int value = this.getInt();
                double longitude = (double)value * 360.0 / 4.294967296E9;
                return longitude;
            }
        }
        return new LongitudeRequest();
    }

    public IDataRequest<Double> getElevation1(boolean bFeet) {
        if (!bFeet) {
            class ElevationRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                ElevationRequest() {
                    this.offset = NavRadioHelper.this.elevationOffset1;
                    this.dataBuffer = new byte[4];
                }

                @Override
                public Double getValue() {
                    int elevation = this.getInt();
                    return elevation;
                }
            }
            return new ElevationRequest();
        }
        class ElevationRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            ElevationRequest() {
                this.offset = NavRadioHelper.this.elevationOffset1;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Double getValue() {
                int elevation = this.getInt();
                return (double)elevation * 3.2808;
            }
        }
        return new ElevationRequest();
    }

    public IDataRequest<Double> getElevation2(boolean bFeet) {
        if (!bFeet) {
            class ElevationRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                ElevationRequest() {
                    this.offset = NavRadioHelper.this.elevationOffset2;
                    this.dataBuffer = new byte[4];
                }

                @Override
                public Double getValue() {
                    int elevation = this.getInt();
                    return elevation;
                }
            }
            return new ElevationRequest();
        }
        class ElevationRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            ElevationRequest() {
                this.offset = NavRadioHelper.this.elevationOffset2;
                this.dataBuffer = new byte[4];
            }

            @Override
            public Double getValue() {
                int elevation = this.getInt();
                return (double)elevation * 3.2808;
            }
        }
        return new ElevationRequest();
    }

    public IDataRequest<Float> getILSGlideslopeInclination(boolean bDegrees) {
        if (bDegrees) {
            class ILSGSInclinationRequest
            extends DataRequest
            implements IReadOnlyRequest<Float> {
                ILSGSInclinationRequest() {
                    this.offset = NavRadioHelper.this.ilsGlideSlopeInclinationOffset;
                    this.dataBuffer = new byte[2];
                }

                @Override
                public Float getValue() {
                    short value = this.getShort();
                    float inclination = (float)(value * 360) / 65536.0f;
                    return Float.valueOf(inclination);
                }
            }
            return new ILSGSInclinationRequest();
        }
        class ILSGSInclinationRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            ILSGSInclinationRequest() {
                this.offset = NavRadioHelper.this.ilsGlideSlopeInclinationOffset;
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short value = this.getShort();
                float inclination = (float)(value * 360) / 65536.0f;
                return Float.valueOf((float)Math.toRadians(inclination));
            }
        }
        return new ILSGSInclinationRequest();
    }

    public IDataRequest<Float> getILSLocaliserInverseRunwayHeading() {
        class ILSLocInvRWHeadingRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            ILSLocInvRWHeadingRequest() {
                this.offset = NavRadioHelper.this.ilsInverseRunwayHeadingOffset;
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short value = this.getShort();
                float invHeading = (float)(value * 360) / 65536.0f;
                return Float.valueOf(invHeading);
            }
        }
        return new ILSLocInvRWHeadingRequest();
    }

    public IDataRequest<Float> getDMEDistance() {
        class DMEDistanceRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            DMEDistanceRequest() {
                this.offset = NavRadioHelper.this.dmeDistanceOffset;
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short value = this.getShort();
                return Float.valueOf((float)value / 10.0f);
            }
        }
        return new DMEDistanceRequest();
    }

    public IDataRequest<Float> getDMESpeed() {
        class DMESpeedRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            DMESpeedRequest() {
                this.offset = NavRadioHelper.this.dmeSpeedOffset;
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short value = this.getShort();
                return Float.valueOf((float)value / 10.0f);
            }
        }
        return new DMESpeedRequest();
    }

    public IDataRequest<Float> getDMETimeToStation() {
        class DMETimeToStationRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            DMETimeToStationRequest() {
                this.offset = NavRadioHelper.this.dmeTimeToStationOffset;
                this.dataBuffer = new byte[2];
            }

            @Override
            public Float getValue() {
                short value = this.getShort();
                return Float.valueOf((float)value / 10.0f);
            }
        }
        return new DMETimeToStationRequest();
    }

    public IDataRequest<String> getName() {
        class NameRequest
        extends DataRequest
        implements IReadOnlyRequest<String> {
            NameRequest() {
                this.offset = NavRadioHelper.this.nameOffset;
                this.dataBuffer = new byte[25];
            }

            @Override
            public String getValue() {
                return new String(this.dataBuffer).trim();
            }
        }
        return new NameRequest();
    }

    public IDataRequest<String> getIdentity() {
        class IdentityRequest
        extends DataRequest
        implements IReadOnlyRequest<String> {
            IdentityRequest() {
                this.offset = NavRadioHelper.this.identityOffset;
                this.dataBuffer = new byte[6];
            }

            @Override
            public String getValue() {
                return new String(this.dataBuffer).trim();
            }
        }
        return new IdentityRequest();
    }

    public static enum ToFromFlag {
        NOT_ACTIVE(0),
        TO(1),
        FROM(2);

        private final byte value;
        private static final Map<Byte, ToFromFlag> lookupTable;

        private ToFromFlag(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static ToFromFlag get(byte value) throws InvalidParameterException {
            if (!lookupTable.containsKey(value)) {
                throw new InvalidParameterException("Log severity value: " + value + " NOT supported!");
            }
            return lookupTable.get(value);
        }

        static {
            lookupTable = new HashMap<Byte, ToFromFlag>();
            for (ToFromFlag flag : EnumSet.allOf(ToFromFlag.class)) {
                lookupTable.put(flag.getValue(), flag);
            }
        }
    }

    public class CodeFlags {
        private byte flags;

        public CodeFlags(byte flags) {
            this.flags = flags;
        }

        public void setFlags(byte flags) {
            this.flags = flags;
        }

        public byte getFlags() {
            return this.flags;
        }

        public boolean isDMEActive() {
            return (this.flags & 1) != 0;
        }

        public boolean isTACAN() {
            return (this.flags & 2) != 0;
        }

        public boolean isVoiceAvailable() {
            return (this.flags & 4) != 0;
        }

        public boolean isNoSignal() {
            return (this.flags & 8) != 0;
        }

        public boolean isDMEGSColocated() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isNoBackCourse() {
            return (this.flags & 0x20) != 0;
        }

        public boolean isGSAvailable() {
            return (this.flags & 0x40) != 0;
        }

        public boolean isStationActive() {
            return (this.flags & 0x80) != 0;
        }
    }

    public class BackCourseFlags {
        private byte flags;

        public BackCourseFlags(byte flags) {
            this.flags = flags;
        }

        public void setFlags(byte flags) {
            this.flags = flags;
        }

        public byte getFlags() {
            return this.flags;
        }

        public boolean isAvailable() {
            return (this.flags & 1) != 0;
        }

        public boolean isLocaliserTunedIn() {
            return (this.flags & 2) != 0;
        }

        public boolean isOnBackCourse() {
            return (this.flags & 4) != 0;
        }

        public boolean isStationActive() {
            return (this.flags & 0x80) != 0;
        }
    }
}

