/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.security.InvalidParameterException;

public class IntRequest
extends DataRequest
implements IDataRequest<Integer> {
    public IntRequest() {
        this.dataBuffer = new byte[4];
    }

    public IntRequest(int offset) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public IntRequest(int offset, int value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.putInt(value);
        this.type = IDataRequest.RequestType.WRITE;
    }

    public IntRequest(int offset, Integer value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.putInt(value);
        this.type = IDataRequest.RequestType.WRITE;
    }

    @Override
    public Integer getValue() {
        return this.getInt();
    }

    @Override
    public void setValue(Integer value) {
        this.putInt(value);
    }
}

