/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers;

import com.mouseviator.fsuipc.FSUIPC;
import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IReadOnlyRequest;
import com.mouseviator.fsuipc.datarequest.IWriteOnlyRequest;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LVarHelper {
    public static final int PARAMETER_OFFSET = 3436;
    public static final int CONTROL_OFFSET = 3440;

    public LVarResult readLVar(String lvar, int targetOffset, LVarValueFormat lvarValueFormat, FSUIPC fsuipc, boolean continual) {
        if (fsuipc == null) {
            return null;
        }
        LVarResult result = this.readLVar(lvar, targetOffset, lvarValueFormat);
        if (continual) {
            fsuipc.addContinualRequest(result.getParamRequest());
            fsuipc.addContinualRequest(result.getControlRequest());
            fsuipc.addContinualRequest(result.getResultRequest());
        } else {
            fsuipc.addOneTimeRequest(result.getParamRequest());
            fsuipc.addOneTimeRequest(result.getControlRequest());
            fsuipc.addOneTimeRequest(result.getResultRequest());
        }
        return result;
    }

    public LVarResult readLVar(String lvar, int targetOffset, LVarValueFormat lvarValueFormat) {
        LVarControlRequest controlRequest = new LVarControlRequest(lvar);
        LVarParamRequest paramRequest = new LVarParamRequest(lvarValueFormat.getValue() + targetOffset);
        LVarResult result = new LVarResult(controlRequest, paramRequest, (IDataRequest)((Object)(switch (lvarValueFormat) {
            case LVarValueFormat.FLOAT -> new FloatLVarReadRequest(targetOffset);
            case LVarValueFormat.SIGNED_INTEGER -> new IntegerLVarReadRequest(targetOffset);
            case LVarValueFormat.UNSIGNED_INTEGER -> new IntegerLVarReadRequest(targetOffset);
            case LVarValueFormat.SIGNED_SHORT -> new ShortLVarReadRequest(targetOffset);
            case LVarValueFormat.UNSIGNED_SHORT -> new ShortLVarReadRequest(targetOffset);
            case LVarValueFormat.SIGNED_BYTE -> new ByteLVarReadRequest(targetOffset);
            case LVarValueFormat.UNSIGNED_BYTE -> new ByteLVarReadRequest(targetOffset);
            default -> new DoubleLVarReadRequest(targetOffset);
        })));
        return result;
    }

    public LVarResult writeLVar(String lvar, int lvarValueOffset, double lvarValue) {
        return this.writeLVar(lvar, lvarValueOffset, lvarValue, LVarValueFormat.DOUBLE);
    }

    public LVarResult writeLVar(String lvar, int lvarValueOffset, float lvarValue) {
        return this.writeLVar(lvar, lvarValueOffset, Float.valueOf(lvarValue), LVarValueFormat.FLOAT);
    }

    public LVarResult writeLVar(String lvar, int lvarValueOffset, short lvarValue) {
        return this.writeLVar(lvar, lvarValueOffset, lvarValue, LVarValueFormat.SIGNED_SHORT);
    }

    public LVarResult writeLVar(String lvar, int lvarValueOffset, int lvarValue) {
        return this.writeLVar(lvar, lvarValueOffset, lvarValue, LVarValueFormat.SIGNED_INTEGER);
    }

    public LVarResult writeLVar(String lvar, int lvarValueOffset, byte lvarValue) {
        return this.writeLVar(lvar, lvarValueOffset, lvarValue, LVarValueFormat.SIGNED_BYTE);
    }

    public LVarResult writeLVar(String lvar, int lvarValueOffset, Object lvarValue, LVarValueFormat lvarValueFormat) {
        DataRequest resultRequest;
        LVarControlRequest controlRequest = new LVarControlRequest(LVarControlRequestCommand.WRITE, lvar);
        LVarParamRequest paramRequest = new LVarParamRequest(lvarValueFormat.getValue() + lvarValueOffset);
        try {
            switch (lvarValueFormat) {
                case FLOAT: {
                    resultRequest = new FloatLVarWriteRequest(lvarValueOffset, (Float)lvarValue);
                    break;
                }
                case SIGNED_INTEGER: {
                    resultRequest = new IntegerLVarWriteRequest(lvarValueOffset, (Integer)lvarValue);
                    break;
                }
                case UNSIGNED_INTEGER: {
                    resultRequest = new IntegerLVarWriteRequest(lvarValueOffset, (Integer)lvarValue);
                    break;
                }
                case SIGNED_SHORT: {
                    resultRequest = new ShortLVarWriteRequest(lvarValueOffset, (Short)lvarValue);
                    break;
                }
                case UNSIGNED_SHORT: {
                    resultRequest = new ShortLVarWriteRequest(lvarValueOffset, (Short)lvarValue);
                    break;
                }
                case SIGNED_BYTE: {
                    resultRequest = new ByteLVarWriteRequest(lvarValueOffset, (Byte)lvarValue);
                    break;
                }
                case UNSIGNED_BYTE: {
                    resultRequest = new ByteLVarWriteRequest(lvarValueOffset, (Byte)lvarValue);
                    break;
                }
                default: {
                    resultRequest = new DoubleLVarWriteRequest(lvarValueOffset, (Double)lvarValue);
                    break;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LVarHelper.class.getName()).log(Level.SEVERE, MessageFormat.format("There was an error while preparing param and result requests to write to Lvar: {0}, value: {1}, value type: {2}, offset: {3}", new Object[]{lvar, lvarValue, lvarValueFormat, lvarValueOffset}), ex);
            return null;
        }
        LVarResult result = new LVarResult(controlRequest, paramRequest, (IDataRequest)((Object)resultRequest));
        return result;
    }

    public boolean writeLVar(String lvar, int lvarValueOffset, Object lvarValue, LVarValueFormat lvarValueFormat, FSUIPC fsuipc, boolean continual) {
        if (fsuipc == null) {
            return false;
        }
        LVarResult result = this.writeLVar(lvar, lvarValueOffset, lvarValue, lvarValueFormat);
        if (continual) {
            fsuipc.addContinualRequest(result.getResultRequest());
            fsuipc.addContinualRequest(result.getParamRequest());
            fsuipc.addContinualRequest(result.getControlRequest());
        } else {
            fsuipc.addOneTimeRequest(result.getResultRequest());
            fsuipc.addOneTimeRequest(result.getParamRequest());
            fsuipc.addOneTimeRequest(result.getControlRequest());
        }
        return true;
    }

    public LVarResult createLVar(String lvar, int lvarValueOffset, Object lvarValue, LVarValueFormat lvarValueFormat) {
        DataRequest resultRequest;
        LVarControlRequest controlRequest = new LVarControlRequest(LVarControlRequestCommand.CREATE, lvar);
        LVarParamRequest paramRequest = new LVarParamRequest(lvarValueFormat.getValue() + lvarValueOffset);
        try {
            switch (lvarValueFormat) {
                case FLOAT: {
                    resultRequest = new FloatLVarWriteRequest(lvarValueOffset, (Float)lvarValue);
                    break;
                }
                case SIGNED_INTEGER: {
                    resultRequest = new IntegerLVarWriteRequest(lvarValueOffset, (Integer)lvarValue);
                    break;
                }
                case UNSIGNED_INTEGER: {
                    resultRequest = new IntegerLVarWriteRequest(lvarValueOffset, (Integer)lvarValue);
                    break;
                }
                case SIGNED_SHORT: {
                    resultRequest = new ShortLVarWriteRequest(lvarValueOffset, (Short)lvarValue);
                    break;
                }
                case UNSIGNED_SHORT: {
                    resultRequest = new ShortLVarWriteRequest(lvarValueOffset, (Short)lvarValue);
                    break;
                }
                case SIGNED_BYTE: {
                    resultRequest = new ByteLVarWriteRequest(lvarValueOffset, (Byte)lvarValue);
                    break;
                }
                case UNSIGNED_BYTE: {
                    resultRequest = new ByteLVarWriteRequest(lvarValueOffset, (Byte)lvarValue);
                    break;
                }
                default: {
                    resultRequest = new DoubleLVarWriteRequest(lvarValueOffset, (Double)lvarValue);
                    break;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LVarHelper.class.getName()).log(Level.SEVERE, MessageFormat.format("There was an error while preparing param and result requests to create Lvar: {0}, value: {1}, value type: {2}, offset: {3}", new Object[]{lvar, lvarValue, lvarValueFormat, lvarValueOffset}), ex);
            return null;
        }
        LVarResult result = new LVarResult(controlRequest, paramRequest, (IDataRequest)((Object)resultRequest));
        return result;
    }

    public LVarResult createLVar(String lvar, int lvarValueOffset, double lvarValue) {
        return this.createLVar(lvar, lvarValueOffset, lvarValue, LVarValueFormat.DOUBLE);
    }

    public LVarResult createLVar(String lvar, int lvarValueOffset, float lvarValue) {
        return this.createLVar(lvar, lvarValueOffset, Float.valueOf(lvarValue), LVarValueFormat.FLOAT);
    }

    public LVarResult createLVar(String lvar, int lvarValueOffset, int lvarValue) {
        return this.createLVar(lvar, lvarValueOffset, lvarValue, LVarValueFormat.SIGNED_INTEGER);
    }

    public LVarResult createLVar(String lvar, int lvarValueOffset, short lvarValue) {
        return this.createLVar(lvar, lvarValueOffset, lvarValue, LVarValueFormat.SIGNED_SHORT);
    }

    public LVarResult createLVar(String lvar, int lvarValueOffset, byte lvarValue) {
        return this.createLVar(lvar, lvarValueOffset, lvarValue, LVarValueFormat.SIGNED_BYTE);
    }

    public boolean createLVar(String lvar, int lvarValueOffset, Object lvarValue, LVarValueFormat lvarValueFormat, FSUIPC fsuipc) {
        if (fsuipc == null) {
            return false;
        }
        LVarResult result = this.createLVar(lvar, lvarValueOffset, lvarValue, lvarValueFormat);
        fsuipc.addOneTimeRequest(result.getResultRequest());
        fsuipc.addOneTimeRequest(result.getParamRequest());
        fsuipc.addOneTimeRequest(result.getControlRequest());
        return true;
    }

    public static enum LVarValueFormat {
        DOUBLE(0),
        FLOAT(65536),
        SIGNED_INTEGER(131072),
        UNSIGNED_INTEGER(196608),
        SIGNED_SHORT(262144),
        UNSIGNED_SHORT(327680),
        SIGNED_BYTE(393216),
        UNSIGNED_BYTE(458752);

        private final int value;
        private static final Map<Integer, LVarValueFormat> lookupTable;

        private LVarValueFormat(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LVarValueFormat get(int value) throws InvalidParameterException {
            if (!lookupTable.containsKey(value)) {
                throw new InvalidParameterException("Value fromat: " + value + " NOT supported!");
            }
            return lookupTable.get(value);
        }

        static {
            lookupTable = new HashMap<Integer, LVarValueFormat>();
            for (LVarValueFormat type : EnumSet.allOf(LVarValueFormat.class)) {
                lookupTable.put(type.getValue(), type);
            }
        }
    }

    public static class LVarResult {
        private IDataRequest resultRequest = null;
        private LVarParamRequest paramRequest = null;
        private LVarControlRequest controlRequest = null;

        public LVarResult() {
        }

        public LVarResult(LVarControlRequest controlRequest, LVarParamRequest paramRequest, IDataRequest resultRequest) {
            this.controlRequest = controlRequest;
            this.paramRequest = paramRequest;
            this.resultRequest = resultRequest;
        }

        public LVarParamRequest getParamRequest() {
            return this.paramRequest;
        }

        public void setParamRequest(LVarParamRequest paramRequest) {
            this.paramRequest = paramRequest;
        }

        public LVarControlRequest getControlRequest() {
            return this.controlRequest;
        }

        public void setControlRequest(LVarControlRequest controlRequest) {
            this.controlRequest = controlRequest;
        }

        public IDataRequest getResultRequest() {
            return this.resultRequest;
        }

        public void setResultRequest(IDataRequest resultRequest) {
            this.resultRequest = resultRequest;
        }
    }

    public static class LVarParamRequest
    extends DataRequest
    implements IWriteOnlyRequest<Integer> {
        public LVarParamRequest(Integer value) {
            this.dataBuffer = new byte[4];
            this.offset = 3436;
            this.type = IDataRequest.RequestType.WRITE;
            this.putInt(value);
        }

        @Override
        public void setValue(Integer value) {
            this.putInt(value);
        }
    }

    public static class LVarControlRequest
    extends DataRequest
    implements IWriteOnlyRequest<String> {
        private LVarControlRequestCommand command;
        private Charset charset = Charset.forName("UTF-8");

        public LVarControlRequest(String lvar) {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.command = LVarControlRequestCommand.READ;
            this.convertStringToByteArray(this.command.getValue() + lvar, 0, this.charset);
        }

        public LVarControlRequest(String lvar, Charset charset) {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.command = LVarControlRequestCommand.READ;
            if (charset != null) {
                this.charset = charset;
            }
            this.convertStringToByteArray(this.command.getValue() + lvar, 0, charset);
        }

        public LVarControlRequest(LVarControlRequestCommand command, String lvar) {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.command = LVarControlRequestCommand.READ;
            this.command = command;
            this.convertStringToByteArray(this.command.getValue() + lvar, 0, this.charset);
        }

        public LVarControlRequest(LVarControlRequestCommand command, String lvar, Charset charset) {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.command = LVarControlRequestCommand.READ;
            if (charset != null) {
                this.charset = charset;
            }
            this.command = command;
            this.convertStringToByteArray(this.command.getValue() + lvar, 0, charset);
        }

        @Override
        public void setValue(String value) {
            this.convertStringToByteArray(this.command.getValue() + value, 0, this.charset);
        }

        public LVarControlRequestCommand getCommand() {
            return this.command;
        }

        public void setCommand(LVarControlRequestCommand command) {
            String currValue = new String(this.dataBuffer, this.charset).trim();
            String lvar = currValue.replace(this.command.getValue(), "").trim();
            this.command = command;
            this.convertStringToByteArray(this.command.getValue() + lvar, 0, this.charset);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }
    }

    public static class FloatLVarReadRequest
    extends DataRequest
    implements IReadOnlyRequest<Float> {
        public FloatLVarReadRequest(int offset) {
            this.dataBuffer = new byte[4];
            this.offset = offset;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.getFloat());
        }
    }

    public static class IntegerLVarReadRequest
    extends DataRequest
    implements IReadOnlyRequest<Integer> {
        public IntegerLVarReadRequest(int offset) {
            this.dataBuffer = new byte[4];
            this.offset = offset;
        }

        @Override
        public Integer getValue() {
            return this.getInt();
        }
    }

    public static class ShortLVarReadRequest
    extends DataRequest
    implements IReadOnlyRequest<Short> {
        public ShortLVarReadRequest(int offset) {
            this.dataBuffer = new byte[2];
            this.offset = offset;
        }

        @Override
        public Short getValue() {
            return this.getShort();
        }
    }

    public static class ByteLVarReadRequest
    extends DataRequest
    implements IReadOnlyRequest<Byte> {
        public ByteLVarReadRequest(int offset) {
            this.dataBuffer = new byte[1];
            this.offset = offset;
        }

        @Override
        public Byte getValue() {
            return this.dataBuffer[0];
        }
    }

    public static class DoubleLVarReadRequest
    extends DataRequest
    implements IReadOnlyRequest<Double> {
        public DoubleLVarReadRequest(int offset) {
            this.dataBuffer = new byte[8];
            this.offset = offset;
        }

        @Override
        public Double getValue() {
            return this.getDouble();
        }
    }

    public static enum LVarControlRequestCommand {
        READ(":"),
        WRITE("::"),
        CREATE(":::");

        private final String value;
        private static final Map<String, LVarControlRequestCommand> lookupTable;

        private LVarControlRequestCommand(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static LVarControlRequestCommand get(String value) throws InvalidParameterException {
            if (!lookupTable.containsKey(value)) {
                throw new InvalidParameterException("Command value: " + value + " NOT supported!");
            }
            return lookupTable.get(value);
        }

        static {
            lookupTable = new HashMap<String, LVarControlRequestCommand>();
            for (LVarControlRequestCommand type : EnumSet.allOf(LVarControlRequestCommand.class)) {
                lookupTable.put(type.getValue(), type);
            }
        }
    }

    public static class FloatLVarWriteRequest
    extends DataRequest
    implements IWriteOnlyRequest<Float> {
        public FloatLVarWriteRequest(int offset, Float value) {
            this.dataBuffer = new byte[4];
            this.putFloat(value);
            this.offset = offset;
            this.type = IDataRequest.RequestType.WRITE;
        }

        @Override
        public void setValue(Float value) {
            this.putFloat(value);
        }
    }

    public static class IntegerLVarWriteRequest
    extends DataRequest
    implements IWriteOnlyRequest<Integer> {
        public IntegerLVarWriteRequest(int offset, Integer value) {
            this.dataBuffer = new byte[4];
            this.putInt(value);
            this.offset = offset;
            this.type = IDataRequest.RequestType.WRITE;
        }

        @Override
        public void setValue(Integer value) {
            this.putInt(value);
        }
    }

    public static class ShortLVarWriteRequest
    extends DataRequest
    implements IWriteOnlyRequest<Short> {
        public ShortLVarWriteRequest(int offset, Short value) {
            this.dataBuffer = new byte[2];
            this.putShort(value);
            this.offset = offset;
            this.type = IDataRequest.RequestType.WRITE;
        }

        @Override
        public void setValue(Short value) {
            this.putShort(value);
        }
    }

    public static class ByteLVarWriteRequest
    extends DataRequest
    implements IWriteOnlyRequest<Byte> {
        public ByteLVarWriteRequest(int offset, Byte value) {
            this.dataBuffer = new byte[1];
            this.dataBuffer[0] = value;
            this.offset = offset;
            this.type = IDataRequest.RequestType.WRITE;
        }

        @Override
        public void setValue(Byte value) {
            this.dataBuffer[0] = value;
        }
    }

    public static class DoubleLVarWriteRequest
    extends DataRequest
    implements IWriteOnlyRequest<Double> {
        public DoubleLVarWriteRequest(int offset, Double value) {
            this.dataBuffer = new byte[8];
            this.putDouble(value);
            this.offset = offset;
            this.type = IDataRequest.RequestType.WRITE;
        }

        @Override
        public void setValue(Double value) {
            this.putDouble(value);
        }
    }
}

