/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.example;

import com.mouseviator.fsuipc.FSUIPC;
import com.mouseviator.fsuipc.FSUIPCWrapper;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.primitives.DoubleRequest;
import com.mouseviator.fsuipc.datarequest.primitives.FloatRequest;
import com.mouseviator.fsuipc.datarequest.primitives.IntRequest;
import com.mouseviator.fsuipc.datarequest.primitives.ShortRequest;
import com.mouseviator.fsuipc.datarequest.primitives.StringRequest;
import com.mouseviator.fsuipc.helpers.SimHelper;
import com.mouseviator.fsuipc.helpers.aircraft.AircraftHelper;
import com.mouseviator.fsuipc.helpers.avionics.COM1Helper;
import com.mouseviator.fsuipc.helpers.avionics.COM2Helper;
import com.mouseviator.fsuipc.helpers.avionics.GPSHelper;
import com.mouseviator.fsuipc.helpers.avionics.NAV1Helper;
import com.mouseviator.fsuipc.helpers.avionics.NAV2Helper;

public class FSUIPCSimpleTest {
    public static void main(String[] args) {
        FSUIPC fsuipc = FSUIPC.getInstance();
        byte result = FSUIPC.load();
        if (result != 0) {
            System.out.println("Failed to load native library. Quiting...");
            return;
        }
        FSUIPCWrapper.setupLogging(true, FSUIPCWrapper.LogSeverity.DEBUG.getValue());
        System.out.println("Running tests");
        int ret = fsuipc.connect(FSUIPCWrapper.FSUIPCSimVersion.SIM_ANY);
        System.out.println("ret =" + ret);
        if (ret == 0) {
            System.out.println("Flight sim not found");
        } else {
            System.out.println("Flight Sim found!");
            System.out.println("FSUIPC Version: " + String.valueOf(FSUIPCWrapper.getVersion()));
            System.out.println("FSUIPC Version (string): " + fsuipc.getVersion());
            System.out.println("FSUIPC FS Version: " + String.valueOf(FSUIPCWrapper.getFSVersion()));
            System.out.println("FSUIPC FS Version (string): " + fsuipc.getFSVersion());
            System.out.println("FSUIPC Lib Version: " + String.valueOf(FSUIPCWrapper.getLibVersion()));
            System.out.println("FSUIPC Lib Version (string): " + fsuipc.getLibVersion());
            GPSHelper gpsHelper = new GPSHelper();
            AircraftHelper aircraftHelper = new AircraftHelper();
            SimHelper simHelper = new SimHelper();
            COM1Helper com1Helper = new COM1Helper();
            COM2Helper com2Helper = new COM2Helper();
            NAV1Helper nav1Helper = new NAV1Helper();
            NAV2Helper nav2Helper = new NAV2Helper();
            IDataRequest on_ground = fsuipc.addOneTimeRequest(aircraftHelper.getOnGround());
            IDataRequest fsxp3dVersion = fsuipc.addOneTimeRequest(simHelper.getFSXP3DVersion());
            ShortRequest eng1_thr = (ShortRequest)fsuipc.addOneTimeRequest(new ShortRequest(2188));
            ShortRequest eng2_thr = (ShortRequest)fsuipc.addOneTimeRequest(new ShortRequest(2340));
            FloatRequest ias = (FloatRequest)fsuipc.addOneTimeRequest(aircraftHelper.getIAS());
            FloatRequest tas = (FloatRequest)fsuipc.addOneTimeRequest(aircraftHelper.getTAS());
            FloatRequest vs = (FloatRequest)fsuipc.addOneTimeRequest(aircraftHelper.getVerticalSpeed(true));
            DoubleRequest altitude = (DoubleRequest)fsuipc.addOneTimeRequest(aircraftHelper.getAltitude(true));
            DoubleRequest latitude = (DoubleRequest)fsuipc.addOneTimeRequest(aircraftHelper.getLatitude());
            DoubleRequest longitude = (DoubleRequest)fsuipc.addOneTimeRequest(aircraftHelper.getLongitude());
            IDataRequest gps_latitude = fsuipc.addOneTimeRequest(gpsHelper.getLatitude());
            IDataRequest gps_longitude = fsuipc.addOneTimeRequest(gpsHelper.getLongitude());
            FloatRequest true_heading = (FloatRequest)fsuipc.addOneTimeRequest(aircraftHelper.getHeading());
            FloatRequest bank = (FloatRequest)fsuipc.addOneTimeRequest(aircraftHelper.getBank());
            FloatRequest pitch = (FloatRequest)fsuipc.addOneTimeRequest(aircraftHelper.getPitch());
            IDataRequest magVar = fsuipc.addOneTimeRequest(aircraftHelper.getMagneticVariation());
            IDataRequest num_of_engines = fsuipc.addOneTimeRequest(aircraftHelper.getNumberOfEngines());
            IDataRequest gps_altitude = fsuipc.addOneTimeRequest(gpsHelper.getAltitude(true));
            IDataRequest engine_type = fsuipc.addOneTimeRequest(aircraftHelper.getEngineType());
            IDataRequest situation_file = fsuipc.addOneTimeRequest(simHelper.getSituationFile());
            StringRequest atc_flight_num = (StringRequest)fsuipc.addOneTimeRequest(aircraftHelper.getATCFlightNumber());
            StringRequest atc_ident = (StringRequest)fsuipc.addOneTimeRequest(aircraftHelper.getATCIdent());
            FloatRequest com1_frequency = (FloatRequest)fsuipc.addOneTimeRequest(com1Helper.getFrequency());
            FloatRequest com2_frequency = (FloatRequest)fsuipc.addOneTimeRequest(com2Helper.getFrequency());
            FloatRequest nav1_frequency = (FloatRequest)fsuipc.addOneTimeRequest(nav1Helper.getFrequency());
            FloatRequest nav2_frequency = (FloatRequest)fsuipc.addOneTimeRequest(nav2Helper.getFrequency());
            IDataRequest nav1_name = fsuipc.addOneTimeRequest(nav1Helper.getName());
            IDataRequest nav1_ident = fsuipc.addOneTimeRequest(nav1Helper.getIdentity());
            IDataRequest nav1_cdi = fsuipc.addOneTimeRequest(nav1Helper.getCDINeedle());
            IDataRequest nav1_gsi = fsuipc.addOneTimeRequest(nav1Helper.getGSINeedle());
            IDataRequest nav1_code_flag = fsuipc.addOneTimeRequest(nav1Helper.getCodeFlags());
            IDataRequest nav1_bc_flag = fsuipc.addOneTimeRequest(nav1Helper.getBackCourseFlags());
            IDataRequest nav1_signal_strength = fsuipc.addOneTimeRequest(nav1Helper.getSignalStrength());
            IDataRequest nav1_radial = fsuipc.addOneTimeRequest(nav1Helper.getRadial(true));
            IDataRequest nav1_dme_distance = fsuipc.addOneTimeRequest(nav1Helper.getDMEDistance());
            IDataRequest nav1_dme_speed = fsuipc.addOneTimeRequest(nav1Helper.getDMESpeed());
            IDataRequest nav1_dme_tts = fsuipc.addOneTimeRequest(nav1Helper.getDMETimeToStation());
            IDataRequest nav1_latitude1 = fsuipc.addOneTimeRequest(nav1Helper.getLatitude1());
            IDataRequest nav1_longitude1 = fsuipc.addOneTimeRequest(nav1Helper.getLongitude1());
            IDataRequest nav1_elevation1 = fsuipc.addOneTimeRequest(nav1Helper.getElevation1(true));
            ShortRequest nav1_obs = (ShortRequest)fsuipc.addOneTimeRequest(nav1Helper.getOBSSettings());
            IDataRequest nav1_magvar = fsuipc.addOneTimeRequest(nav1Helper.getMagneticVariation(true));
            IDataRequest nav1_relbearing = fsuipc.addOneTimeRequest(nav1Helper.getVORRelativeBearing());
            IntRequest ias2 = new IntRequest(700);
            fsuipc.addOneTimeRequest(ias2);
            ret = fsuipc.processRequestsOnce();
            System.out.println("FSUIPC processed one time requests with result code: " + String.valueOf(ret));
            if (ret == 500) {
                System.out.println("FSX/P3D version: " + (String)fsxp3dVersion.getValue());
                System.out.println("On ground: " + String.valueOf(on_ground.getValue()));
                System.out.println("Aircraft IAS: " + String.valueOf(ias.getValue()));
                System.out.println("Aircraft IAS (method 2): " + String.valueOf((float)ias2.getValue().intValue() / 128.0f));
                System.out.println("Aircraft TAS: " + String.valueOf(tas.getValue()));
                System.out.println("Aircraft VS: " + String.valueOf(vs.getValue()));
                System.out.println("Aircraft Altitude: " + String.valueOf(altitude.getValue()));
                System.out.println("Aircraft Latitude: " + String.valueOf(latitude.getValue()));
                System.out.println("Aircraft Longitude: " + String.valueOf(longitude.getValue()));
                System.out.println("Aircraft GPS Latitude: " + String.valueOf(gps_latitude.getValue()));
                System.out.println("Aircraft GPS Longitude: " + String.valueOf(gps_longitude.getValue()));
                System.out.println("Aircraft GPS Altitude: " + String.valueOf(gps_altitude.getValue()));
                float fHeading = true_heading.getValue().floatValue();
                float fMagVar = ((Float)magVar.getValue()).floatValue();
                System.out.println("Aircraft TRUE Heading: " + String.valueOf(fHeading));
                System.out.println("Aircraft Magnetic Variation: " + String.valueOf(fMagVar));
                System.out.println("Aircraft Magnetic Heading: " + String.valueOf(fHeading - fMagVar));
                System.out.println("Aircraft Pitch: " + String.valueOf(pitch.getValue()));
                System.out.println("Aircraft Bank: " + String.valueOf(bank.getValue()));
                System.out.println("Aircraft Number Of Engines: " + String.valueOf(num_of_engines.getValue()));
                System.out.println("Aircraft Engine Type: " + String.valueOf(engine_type.getValue()));
                System.out.println("Engine 1 Throttle: " + String.valueOf(eng1_thr.getValue()));
                System.out.println("Engine 2 Throttle: " + String.valueOf(eng2_thr.getValue()));
                System.out.println("Situation file: " + (String)situation_file.getValue());
                System.out.println("ATC flight number: " + atc_flight_num.getValue());
                System.out.println("ATC identification: " + atc_ident.getValue());
                System.out.println("COM1 frequency: " + String.valueOf(com1_frequency.getValue()));
                System.out.println("COM2 frequency: " + String.valueOf(com2_frequency.getValue()));
                System.out.println("NAV1 frequency: " + String.valueOf(nav1_frequency.getValue()));
                System.out.println("NAV2 frequency: " + String.valueOf(nav2_frequency.getValue()));
                System.out.println("NAV1 name: " + (String)nav1_name.getValue());
                System.out.println("NAV1 identity: " + (String)nav1_ident.getValue());
                System.out.println("NAV1 signal strength: " + String.valueOf(nav1_signal_strength.getValue()));
                System.out.println("NAV1 radial: " + String.valueOf(nav1_radial.getValue()));
                System.out.println("NAV1 CDI: " + String.valueOf(nav1_cdi.getValue()));
                System.out.println("NAV1 GSI: " + String.valueOf(nav1_gsi.getValue()));
                System.out.println("NAV1 code flags: " + Integer.toBinaryString(((Byte)nav1_code_flag.getValue()).byteValue()));
                System.out.println("NAV1 back course flags: " + Integer.toBinaryString(((Byte)nav1_bc_flag.getValue()).byteValue()));
                System.out.println("NAV1/VOR1 DME distance: " + String.valueOf(nav1_dme_distance.getValue()) + " Nm");
                System.out.println("NAV1/VOR1 DME speed: " + String.valueOf(nav1_dme_speed.getValue()) + " Kts");
                System.out.println("NAV1/VOR1 DME time to station: " + String.valueOf(nav1_dme_tts.getValue()) + " seconds");
                System.out.println("NAV1/VOR1 (or glideslope transmitter) latitude: " + String.valueOf(nav1_latitude1.getValue()));
                System.out.println("NAV1/VOR1 (or glideslope transmitter) longitude: " + String.valueOf(nav1_longitude1.getValue()));
                System.out.println("NAV1/VOR1 (or glideslope transmitter) elevation: " + String.valueOf(nav1_elevation1.getValue()) + " feet");
                System.out.println("NAV1 OBS settings: " + String.valueOf(nav1_obs.getValue()));
                System.out.println("NAV1/VOR1 magnetic variation: " + String.valueOf(nav1_magvar.getValue()));
                System.out.println("NAV1/VOR1 relative bearing: " + String.valueOf(nav1_relbearing.getValue()));
                com1_frequency.setValue(Float.valueOf(124.88f));
                System.out.println("COM1 frequency: " + String.valueOf(com1_frequency.getValue()));
            }
            fsuipc.disconnect();
        }
    }
}

