/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers.aircraft;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IReadOnlyRequest;
import com.mouseviator.fsuipc.datarequest.primitives.DoubleRequest;
import com.mouseviator.fsuipc.datarequest.primitives.FloatRequest;
import com.mouseviator.fsuipc.datarequest.primitives.StringRequest;
import java.security.InvalidParameterException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class AircraftHelper {
    public FloatRequest getIAS() {
        return new FloatRequest(700){

            @Override
            public Float getValue() {
                int iIAS = this.getInt();
                return Float.valueOf((float)iIAS / 128.0f);
            }

            @Override
            public void setValue(Float value) {
                int iIAS = (int)(value.floatValue() / 128.0f);
                this.putInt(iIAS);
            }
        };
    }

    public FloatRequest getTAS() {
        return new FloatRequest(696){

            @Override
            public Float getValue() {
                int iTAS = this.getInt();
                return Float.valueOf((float)iTAS / 128.0f);
            }

            @Override
            public void setValue(Float value) {
                int iTAS = (int)(value.floatValue() / 128.0f);
                this.putInt(iTAS);
            }
        };
    }

    public FloatRequest getVerticalSpeed(boolean bFPM) {
        if (bFPM) {
            return new FloatRequest(712){

                @Override
                public Float getValue() {
                    int iVS = this.getInt();
                    return Float.valueOf((float)iVS / 256.0f * 60.0f * 3.28084f);
                }

                @Override
                public void setValue(Float value) {
                    int iVS = (int)(value.floatValue() * 256.0f / 60.0f / 3.28084f);
                    this.putInt(iVS);
                }
            };
        }
        return new FloatRequest(712){

            @Override
            public Float getValue() {
                int iVS = this.getInt();
                return Float.valueOf((float)iVS / 256.0f);
            }

            @Override
            public void setValue(Float value) {
                int iVS = (int)(value.floatValue() * 256.0f);
                this.putInt(iVS);
            }
        };
    }

    public DoubleRequest getLatitude() {
        return new DoubleRequest(1376){

            @Override
            public Double getValue() {
                long latitude = this.getLong();
                return (double)latitude * 2.0951091487837895E-15;
            }

            @Override
            public void setValue(Double value) {
                long latitude = (long)(value / 3.86614702374912E18);
                this.putLong(latitude);
            }
        };
    }

    public DoubleRequest getLongitude() {
        return new DoubleRequest(1384){

            @Override
            public Double getValue() {
                long longitude = this.getLong();
                return (double)longitude * 1.951563910473908E-17;
            }

            @Override
            public void setValue(Double value) {
                long longitude = (long)(value / 1.951563910473908E-17);
                this.putLong(longitude);
            }
        };
    }

    public DoubleRequest getAltitude(boolean bFeet) {
        if (!bFeet) {
            return new DoubleRequest(1392){

                @Override
                public void setValue(Double value) {
                    double unit = Math.floor(value);
                    double fraction = value - unit;
                    long altitude = (long)(fraction * 65536.0) + ((long)(unit * 65536.0) << 16);
                    this.putLong(altitude);
                }

                @Override
                public Double getValue() {
                    long altitude = this.getLong();
                    long high_int = altitude >> 16;
                    long low_int = altitude & 0xFFFFL;
                    return (double)high_int / 65536.0 + (double)low_int / 65536.0;
                }
            };
        }
        return new DoubleRequest(1392){

            @Override
            public void setValue(Double value) {
                double in_meters = value / 3.2808;
                double unit = Math.floor(in_meters);
                double fraction = in_meters - unit;
                long altitude = (long)(fraction * 65536.0) + ((long)(unit * 65536.0) << 16);
                this.putLong(altitude);
            }

            @Override
            public Double getValue() {
                long altitude = this.getLong();
                long high_int = altitude >> 16;
                long low_int = altitude & 0xFFFFL;
                return ((double)high_int / 65536.0 + (double)low_int / 65536.0) * 3.2808;
            }
        };
    }

    public IDataRequest<Short> getNumberOfEngines() {
        class NumOfEnginesRequest
        extends DataRequest
        implements IReadOnlyRequest<Short> {
            NumOfEnginesRequest() {
                this.dataBuffer = new byte[2];
                this.offset = 2796;
            }

            @Override
            public Short getValue() {
                return this.getShort();
            }
        }
        return new NumOfEnginesRequest();
    }

    public FloatRequest getPitch() {
        return new FloatRequest(1400){

            @Override
            public Float getValue() {
                int pitch = this.getInt();
                return Float.valueOf((float)pitch * 360.0f / 4.2949673E9f);
            }

            @Override
            public void setValue(Float value) {
                int pitch = (int)(value.floatValue() / 360.0f * 4.2949673E9f);
                this.putInt(pitch);
            }
        };
    }

    public FloatRequest getBank() {
        return new FloatRequest(1404){

            @Override
            public Float getValue() {
                int bank = this.getInt();
                return Float.valueOf((float)bank * 360.0f / 4.2949673E9f);
            }

            @Override
            public void setValue(Float value) {
                int bank = (int)(value.floatValue() / 360.0f * 4.2949673E9f);
                this.putInt(bank);
            }
        };
    }

    public FloatRequest getHeading() {
        return new FloatRequest(1408){

            @Override
            public Float getValue() {
                int heading = this.getInt();
                return Float.valueOf(360.0f + (float)heading * 360.0f / 4.2949673E9f);
            }

            @Override
            public void setValue(Float value) {
                int heading = (int)(360.0f - value.floatValue() / 360.0f * 4.2949673E9f);
                this.putInt(heading);
            }
        };
    }

    public IDataRequest<Float> getMagneticVariation() {
        class MagVarRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            MagVarRequest() {
                this.dataBuffer = new byte[2];
                this.offset = 672;
            }

            @Override
            public Float getValue() {
                short magVar = this.getShort();
                return Float.valueOf((float)magVar * 360.0f / 65536.0f);
            }
        }
        return new MagVarRequest();
    }

    public IDataRequest<Byte> getEngineType() {
        class EngineTypeRequest
        extends DataRequest
        implements IReadOnlyRequest<Byte> {
            EngineTypeRequest() {
                this.dataBuffer = new byte[1];
                this.offset = 1545;
            }

            @Override
            public Byte getValue() {
                return this.dataBuffer[0];
            }
        }
        return new EngineTypeRequest();
    }

    public StringRequest getATCFlightNumber() {
        return new StringRequest(12592, 12);
    }

    public StringRequest getATCIdent() {
        return new StringRequest(12604, 12);
    }

    public StringRequest getATCAirlineName() {
        return new StringRequest(12616, 24);
    }

    public IDataRequest<String> getATCAircraftType() {
        class ATCAircraftTypeRequest
        extends DataRequest
        implements IReadOnlyRequest<String> {
            ATCAircraftTypeRequest() {
                this.dataBuffer = new byte[24];
                this.offset = 12640;
            }

            @Override
            public String getValue() {
                return new String(this.dataBuffer).trim();
            }
        }
        return new ATCAircraftTypeRequest();
    }

    public IDataRequest<Short> getOnGround() {
        class OnGroundRequest
        extends DataRequest
        implements IReadOnlyRequest<Short> {
            OnGroundRequest() {
                this.dataBuffer = new byte[2];
                this.offset = 870;
            }

            @Override
            public Short getValue() {
                return this.getShort();
            }
        }
        return new OnGroundRequest();
    }

    public static enum EngineType {
        PISTON(0),
        JET(1),
        SAILPLANE(2),
        HELO(3),
        ROCKET(4),
        TURBOPROP(5);

        private final byte value;
        private static final Map<Byte, EngineType> lookupTable;

        private EngineType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EngineType get(byte value) throws InvalidParameterException {
            if (!lookupTable.containsKey(value)) {
                throw new InvalidParameterException("EngineType Result value: " + value + " NOT supported!");
            }
            return lookupTable.get(value);
        }

        static {
            lookupTable = new HashMap<Byte, EngineType>();
            EnumSet.allOf(EngineType.class).forEach(result -> lookupTable.put(result.getValue(), (EngineType)((Object)result)));
        }
    }
}

