/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc;

import com.mouseviator.fsuipc.FSUIPCWrapper;
import com.mouseviator.fsuipc.IFSUIPCListener;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.security.InvalidParameterException;
import java.util.AbstractQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FSUIPC {
    public static final int PROCESS_RESULT_REQUESTS_EMPTY = 512;
    public static final int PROCESS_RESULT_REQUESTS_STORE_FAILED = 513;
    public static final int PROCESS_RESULT_REQUESTS_PROCESS_FAILED = 514;
    public static final int PROCESS_RESULT_OK = 500;
    public static final int PROCESS_RESULT_FAILED_TO_CANCEL_THREAD = 515;
    public static final int PROCESS_RESULT_FAILTED_TO_START_THREAD = 516;
    public static final int PROCESS_RESULT_THREAD_ALREADY_RUNNING = 517;
    public static final String LIBRARY_NAME64 = "fsuipc_java64";
    public static final String LIBRARY_NAME32 = "fsuipc_java32";
    public static final byte LIB_LOAD_RESULT_OK = 0;
    public static final byte LIB_LOAD_RESULT_FAILED = 1;
    public static final byte LIB_LOAD_RESULT_ALREADY_LOADED = 3;
    private static boolean libraryLoaded = false;
    private static FSUIPC INSTANCE = null;
    private static final Logger logger = Logger.getLogger(FSUIPC.class.getName());
    public static final HashMap<FSUIPCWrapper.FSUIPCResult, String> FSUIPC_ERROR_MESSAGES = new HashMap<FSUIPCWrapper.FSUIPCResult, String>(){
        {
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_OK, "Okay");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_OPEN, "Attempt to Open when already Open");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_NOFS, "Cannot link to FSUIPC or WideClient");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_REGMSG, "Failed to Register common message with Windows");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_ATOM, "Failed to create Atom for mapping filename");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_MAP, "Failed to create a file mapping object");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_VIEW, "Failed to open a view to the file map");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_VERSION, "Incorrect version of FSUIPC, or not FSUIPC");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_WRONGFS, "Sim is not version requested");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_NOTOPEN, "Call cannot execute, link not Open");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_NODATA, "Call cannot execute: no requests accumulated");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_TIMEOUT, "IPC timed out all retries");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_SENDMSG, "IPC sendmessage failed all retries");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_DATA, "IPC request contains bad data");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_RUNNING, "Maybe running on WideClient, but FS not running on Server, or wrong FSUIPC");
            this.put(FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_SIZE, "Read or Write request cannot be added, memory for Process is full");
        }
    };
    public static final HashMap<FSUIPCWrapper.FSUIPCSimVersion, String> FSUIPC_SIM_VERSION_TEXT = new HashMap<FSUIPCWrapper.FSUIPCSimVersion, String>(){
        {
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_ANY, "Any");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_FS98, "Flight Simulator 98");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_FS2K, "Flight Simulator 2000");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_CFS2, "Combat Flight Simulator 2");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_CFS1, "Combat Flight Simulator 1");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_FLY, "Fly!");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_FS2K2, "Flight Simulator 2002");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_FS2K4, "Flight Simulator 2004");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_FSX, "Flight Simulator X");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_ESP, "ESP");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_P3D, "Prepar3D");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_FSX64, "Flight Simulator X (64bit)");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_P3D64, "Prepar3D (64bit)");
            this.put(FSUIPCWrapper.FSUIPCSimVersion.SIM_MSFS, "Microsoft Flight Simulator (2020)");
        }
    };
    private final AbstractQueue<IDataRequest> arOneTimeRequests = new ConcurrentLinkedQueue<IDataRequest>();
    private final AbstractQueue<IDataRequest> arContinualRequests = new ConcurrentLinkedQueue<IDataRequest>();
    private final List<IFSUIPCListener> arListeners = new LinkedList<IFSUIPCListener>();
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);
    private ScheduledFuture waitForConnectionThread = null;
    private ScheduledFuture continualRequestProcessThread = null;
    private long lastProcessingTime = 0L;

    public static synchronized FSUIPC getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FSUIPC();
        }
        return INSTANCE;
    }

    public static byte load() {
        byte result = 1;
        try {
            String arch = System.getProperty("sun.arch.data.model");
            if (arch.equals("32")) {
                result = FSUIPC.load32();
            } else if (arch.equals("64")) {
                result = FSUIPC.load64();
            } else {
                Logger.getLogger(FSUIPCWrapper.class.getName()).log(Level.SEVERE, "Failed to determine system architecture to decide what version of library to load!");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FSUIPCWrapper.class.getName()).log(Level.SEVERE, "Failed to load native implementation library!", ex);
        }
        return result;
    }

    public static byte load32() {
        byte result = 1;
        if (!libraryLoaded) {
            try {
                System.loadLibrary(LIBRARY_NAME32);
                logger.info("Loaded library: fsuipc_java32");
                libraryLoaded = true;
                result = 0;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to load native implementation library: fsuipc_java32", ex);
                libraryLoaded = false;
            }
        } else {
            result = 3;
        }
        return result;
    }

    public static byte load64() {
        byte result = 1;
        if (!libraryLoaded) {
            try {
                System.loadLibrary(LIBRARY_NAME64);
                logger.info("Loaded library: fsuipc_java64");
                libraryLoaded = true;
                result = 0;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to load native implementation library: fsuipc_java64", ex);
                libraryLoaded = false;
            }
        } else {
            result = 3;
        }
        return result;
    }

    private void checkLastResult() {
        int lastResult = FSUIPCWrapper.getResult();
        if (lastResult != FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_OK.getValue()) {
            logger.log(Level.FINER, "Something did not go as planned! FSUIPC last result code is: {0}. Letting the listeners know!", lastResult);
            this.arListeners.forEach(listener -> listener.onFail(lastResult));
        }
        if (lastResult == FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_NOFS.getValue() || lastResult == FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_NOTOPEN.getValue() || lastResult == FSUIPCWrapper.FSUIPCResult.FSUIPC_ERR_SENDMSG.getValue()) {
            logger.log(Level.FINER, "It seems that connection to FSUIPC has been lost! Last result code is: {0}. Will call disconnect!", lastResult);
            this.setConnected(false);
        }
    }

    private void setConnected(boolean connected) {
        boolean bChange = this.connected.get() != connected;
        this.connected.set(connected);
        if (bChange) {
            if (connected) {
                logger.finer("FSUIPC connected! Canceling thread that waits for FSUIPC connection.");
                this.cancelWaitForConnectionTask();
            } else {
                logger.finer("FSUIPC disconnected! Will cancel continual requests processing thread.");
                this.cancelRequestsProcessing();
            }
            this.arListeners.forEach(listener -> {
                if (connected) {
                    listener.onConnected();
                } else {
                    listener.onDisconnected();
                }
            });
        }
    }

    public boolean addListener(IFSUIPCListener listener) {
        if (listener != null) {
            return this.arListeners.add(listener);
        }
        return false;
    }

    public boolean removeListener(IFSUIPCListener listener) {
        if (listener != null) {
            return this.arListeners.remove(listener);
        }
        return false;
    }

    public int connect(FSUIPCWrapper.FSUIPCSimVersion simVersion) {
        int iRet = FSUIPCWrapper.open(simVersion.getValue());
        if (iRet != 0) {
            logger.info("Connection to FSUIPC opened.");
            this.setConnected(true);
        } else {
            logger.finer("Failed to open connection to FSUIPC!");
            this.setConnected(false);
        }
        return iRet;
    }

    public boolean waitForConnection(FSUIPCWrapper.FSUIPCSimVersion simVersion, int repeatPeriod) {
        try {
            if (this.cancelWaitForConnectionTask()) {
                this.waitForConnectionThread = this.scheduledExecutorService.scheduleAtFixedRate(new WaitForConnectionWorker(simVersion), 0L, repeatPeriod, TimeUnit.SECONDS);
                logger.log(Level.FINER, "Started new task to wait to connection to sim via FSUIPC. Required sim version is: {0} and repeat period is: {1} seoonds.", new Object[]{this.getFSVersion(simVersion), repeatPeriod});
                return true;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to schedule new task to wait for FSUIPC connection.", ex);
        }
        return false;
    }

    private boolean cancelWaitForConnectionTask() {
        try {
            if (this.waitForConnectionThread != null) {
                ((ScheduledThreadPoolExecutor)this.scheduledExecutorService).setRemoveOnCancelPolicy(true);
                this.waitForConnectionThread.cancel(true);
                logger.finer("Thread to wait for FSUIPC connection was canceled!");
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to cancel thread waiting for FSUIPC connection!", ex);
            return false;
        }
        return true;
    }

    public boolean cancelRequestsProcessing() {
        try {
            if (this.continualRequestProcessThread != null) {
                ((ScheduledThreadPoolExecutor)this.scheduledExecutorService).setRemoveOnCancelPolicy(true);
                this.continualRequestProcessThread.cancel(false);
                while (!this.continualRequestProcessThread.isDone()) {
                    Thread.sleep(50L);
                }
                logger.finer("Thread for FSUIPC continual requests processing was canceled!");
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to cancel thread for FSUIPC continual requests processing!", ex);
            return false;
        }
        return true;
    }

    public void disconnect() {
        logger.info("Called disconnect! Will close FSUIPC connection and release resoures.");
        this.setConnected(false);
        this.cancelWaitForConnectionTask();
        try {
            this.scheduledExecutorService.shutdown();
            while (!this.scheduledExecutorService.isShutdown()) {
                Thread.sleep(50L);
            }
            logger.finer("All scheduled threads stopped and executor service terminated.");
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to terminate all scheduled threads and to stop executor service!", ex);
        }
        FSUIPCWrapper.close();
    }

    public FSUIPCWrapper.FSUIPCResult getLastResult() throws InvalidParameterException {
        return FSUIPCWrapper.FSUIPCResult.get(FSUIPCWrapper.getResult());
    }

    public String getLastErrorMessage() throws InvalidParameterException {
        return FSUIPC_ERROR_MESSAGES.get((Object)this.getLastResult());
    }

    public String getFSVersion() {
        try {
            FSUIPCWrapper.FSUIPCSimVersion simVersion = FSUIPCWrapper.FSUIPCSimVersion.get(FSUIPCWrapper.getFSVersion());
            return FSUIPC_SIM_VERSION_TEXT.get((Object)simVersion);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to get FS version!", ex);
            return "";
        }
    }

    public String getFSVersion(FSUIPCWrapper.FSUIPCSimVersion simVersion) {
        try {
            return FSUIPC_SIM_VERSION_TEXT.get((Object)simVersion);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to get FS version!", ex);
            return "";
        }
    }

    public String getVersion() {
        int version = FSUIPCWrapper.getVersion();
        String sVersion = String.format("%c.%c%c%c%c", Character.valueOf((char)(48 + (0xF & version >> 28))), Character.valueOf((char)(48 + (0xF & version >> 24))), Character.valueOf((char)(48 + (0xF & version >> 20))), Character.valueOf((char)(48 + (0xF & version >> 16))), Character.valueOf((version & 0xFFFF) > 0 ? (char)(97 + (version & 0xFF) - 1) : (char)' '));
        return sVersion;
    }

    public String getLibVersion() {
        int version = FSUIPCWrapper.getLibVersion();
        return String.format("%.3f", Float.valueOf((float)version / 1000.0f));
    }

    public IDataRequest addOneTimeRequest(IDataRequest dataRequest) {
        if (dataRequest != null) {
            this.arOneTimeRequests.add(dataRequest);
            return dataRequest;
        }
        return null;
    }

    public IDataRequest addContinualRequest(IDataRequest dataRequest) {
        if (dataRequest != null) {
            this.arContinualRequests.add(dataRequest);
            return dataRequest;
        }
        return null;
    }

    public boolean removeContinualRequest(IDataRequest dataRequest) {
        return this.arContinualRequests.remove(dataRequest);
    }

    public boolean clearContinualRequests() {
        boolean bRet = this.cancelRequestsProcessing();
        this.arContinualRequests.clear();
        return bRet;
    }

    public AbstractQueue<IDataRequest> getOneTimeRequests() {
        return this.arOneTimeRequests;
    }

    private int registerRequests(AbstractQueue<IDataRequest> arRequests) {
        IDataRequest dataRequest;
        int iRet = 0;
        if (arRequests.isEmpty()) {
            return 512;
        }
        Iterator iterator = arRequests.iterator();
        while (iterator.hasNext() && (iRet = (dataRequest = (IDataRequest)iterator.next()).getType() == IDataRequest.RequestType.READ ? FSUIPCWrapper.read(dataRequest.getOffset(), dataRequest.getSize(), dataRequest.getDataBuffer()) : FSUIPCWrapper.write(dataRequest.getOffset(), dataRequest.getSize(), dataRequest.getDataBuffer())) != 0) {
        }
        if (iRet == 0) {
            this.checkLastResult();
            return 513;
        }
        return 500;
    }

    private int process() {
        long startTime = System.nanoTime();
        int iRet = FSUIPCWrapper.process();
        this.lastProcessingTime = System.nanoTime() - startTime;
        if (iRet == 0) {
            this.checkLastResult();
            return 514;
        }
        return 500;
    }

    public int processRequestsOnce() {
        int iRet = this.registerRequests(this.arOneTimeRequests);
        if (iRet == 500 && (iRet = this.process()) == 500) {
            this.arOneTimeRequests.clear();
        }
        return iRet;
    }

    public int processRequests(int repeatPeriod, boolean cancelRunning) {
        if (this.continualRequestProcessThread != null) {
            if (cancelRunning) {
                if (!this.cancelRequestsProcessing()) {
                    return 515;
                }
            } else {
                return 517;
            }
        }
        try {
            this.continualRequestProcessThread = this.scheduledExecutorService.scheduleAtFixedRate(new ContinualRequestsProcessWorker(), 0L, repeatPeriod, TimeUnit.MILLISECONDS);
            logger.log(Level.FINER, "Started thread to process continual requests at period of: {0} miliseconds.", repeatPeriod);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to start thread to process continual requests!", ex);
            return 516;
        }
        return 500;
    }

    public long getLastProcessingTime() {
        return this.lastProcessingTime;
    }

    private class ContinualRequestsProcessWorker
    implements Runnable {
        private ContinualRequestsProcessWorker() {
        }

        @Override
        public void run() {
            FSUIPC.this.registerRequests(FSUIPC.this.arOneTimeRequests);
            FSUIPC.this.registerRequests(FSUIPC.this.arContinualRequests);
            int iRet = FSUIPC.this.process();
            if (iRet == 500) {
                FSUIPC.this.arOneTimeRequests.clear();
            }
            if (FSUIPC.this.connected.get()) {
                FSUIPC.this.arListeners.forEach(listener -> listener.onProcess(FSUIPC.this.arContinualRequests));
            }
        }
    }

    private class WaitForConnectionWorker
    implements Runnable {
        FSUIPCWrapper.FSUIPCSimVersion simVersion = FSUIPCWrapper.FSUIPCSimVersion.SIM_ANY;
        private int result = 0;

        public WaitForConnectionWorker(FSUIPCWrapper.FSUIPCSimVersion simVersion) {
            this.simVersion = simVersion;
        }

        @Override
        public void run() {
            this.result = FSUIPCWrapper.open(this.simVersion.getValue());
            if (this.result != 0) {
                FSUIPC.this.setConnected(true);
            }
        }

        public int getResult() {
            return this.result;
        }
    }
}

