/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidParameterException;

public class DoubleRequest
extends DataRequest
implements IDataRequest<Double> {
    public DoubleRequest() {
        this.dataBuffer = new byte[8];
    }

    public DoubleRequest(int offset) {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public DoubleRequest(int offset, double value) {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putDouble(value);
        buf.get(this.dataBuffer);
        this.type = IDataRequest.RequestType.WRITE;
    }

    public DoubleRequest(int offset, Double value) {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putDouble(value);
        buf.get(this.dataBuffer);
        this.type = IDataRequest.RequestType.WRITE;
    }

    @Override
    public Double getValue() {
        return this.getDouble();
    }

    @Override
    public void setValue(Double value) {
        this.putDouble(value);
    }
}

