/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IReadOnlyRequest;
import com.mouseviator.fsuipc.datarequest.IWriteOnlyRequest;
import com.mouseviator.fsuipc.datarequest.primitives.IntRequest;
import java.text.DecimalFormat;
import java.time.LocalTime;

public class SimHelper {
    public IDataRequest<String> getSituationFile() {
        class SituationFileRequest
        extends DataRequest
        implements IReadOnlyRequest<String> {
            SituationFileRequest() {
                this.dataBuffer = new byte[256];
                this.offset = 36;
            }

            @Override
            public String getValue() {
                return new String(this.dataBuffer).trim();
            }
        }
        return new SituationFileRequest();
    }

    public IntRequest getLocalTime() {
        return new IntRequest(568){
            {
                this.dataBuffer = new byte[3];
            }

            @Override
            public void setValue(Integer value) {
                LocalTime time = LocalTime.ofSecondOfDay(value.intValue());
                this.dataBuffer[0] = (byte)time.getHour();
                this.dataBuffer[1] = (byte)time.getMinute();
                this.dataBuffer[2] = (byte)time.getSecond();
            }

            @Override
            public Integer getValue() {
                LocalTime time = LocalTime.of(this.dataBuffer[0], this.dataBuffer[1], this.dataBuffer[2]);
                return time.toSecondOfDay();
            }
        };
    }

    public IDataRequest<Short> getPauseIndicator() {
        class PauseIndicatorRequest
        extends DataRequest
        implements IReadOnlyRequest<Short> {
            PauseIndicatorRequest() {
                this.dataBuffer = new byte[2];
                this.offset = 612;
            }

            @Override
            public Short getValue() {
                return this.getShort();
            }
        }
        return new PauseIndicatorRequest();
    }

    public IDataRequest<Short> setPause(boolean bPause) {
        class PauseRequest
        extends DataRequest
        implements IWriteOnlyRequest<Short> {
            PauseRequest() {
                this.dataBuffer = new byte[2];
                this.offset = 610;
                this.type = IDataRequest.RequestType.WRITE;
            }

            @Override
            public void setValue(Short value) {
                this.putShort(value);
            }
        }
        PauseRequest request = new PauseRequest();
        if (bPause) {
            request.setValue((short)1);
        } else {
            request.setValue((short)0);
        }
        return request;
    }

    public IDataRequest<Short> getSeason() {
        class SeasonRequest
        extends DataRequest
        implements IReadOnlyRequest<Short> {
            SeasonRequest() {
                this.dataBuffer = new byte[2];
                this.offset = 584;
            }

            @Override
            public Short getValue() {
                return this.getShort();
            }
        }
        return new SeasonRequest();
    }

    public IDataRequest<Double> getGroundAltitude(boolean bFeet) {
        if (!bFeet) {
            class GroundAltitudeRequest
            extends DataRequest
            implements IReadOnlyRequest<Double> {
                GroundAltitudeRequest() {
                    this.dataBuffer = new byte[4];
                    this.offset = 32;
                }

                @Override
                public Double getValue() {
                    int altitude = this.getInt();
                    return (double)altitude / 256.0;
                }
            }
            return new GroundAltitudeRequest();
        }
        class GroundAltitudeRequest
        extends DataRequest
        implements IReadOnlyRequest<Double> {
            GroundAltitudeRequest() {
                this.dataBuffer = new byte[4];
                this.offset = 32;
            }

            @Override
            public Double getValue() {
                int altitude = this.getInt();
                return (double)altitude / 256.0 * 3.2808;
            }
        }
        return new GroundAltitudeRequest();
    }

    public IDataRequest<Integer> getFSUIPCAssignedMemorySize() {
        class FSUIPCMemRequest
        extends DataRequest
        implements IReadOnlyRequest<Integer> {
            FSUIPCMemRequest() {
                this.dataBuffer = new byte[4];
                this.offset = 600;
            }

            @Override
            public Integer getValue() {
                return this.getInt();
            }
        }
        return new FSUIPCMemRequest();
    }

    public IDataRequest<Float> getFrameRate() {
        class FrameRateRequest
        extends DataRequest
        implements IReadOnlyRequest<Float> {
            FrameRateRequest() {
                this.dataBuffer = new byte[2];
                this.offset = 628;
            }

            @Override
            public Float getValue() {
                return Float.valueOf(32768.0f / (float)this.getShort());
            }
        }
        return new FrameRateRequest();
    }

    public IDataRequest<String> getFSXP3DVersion() {
        class FSXP3DVersionRequest
        extends DataRequest
        implements IReadOnlyRequest<String> {
            FSXP3DVersionRequest() {
                this.offset = 12580;
                this.dataBuffer = new byte[1];
            }

            @Override
            public String getValue() {
                byte version = this.dataBuffer[0];
                DecimalFormat decimalFormat1 = new DecimalFormat("#.#");
                if (version < 10) {
                    switch (version) {
                        case 1: {
                            return "FSX RTM";
                        }
                        case 2: {
                            return "FSX SP1";
                        }
                        case 3: {
                            return "FSX SP2";
                        }
                        case 4: {
                            return "FSX Acceleration";
                        }
                    }
                    return "FSX (Unknown version)";
                }
                if (version >= 10 && version <= 100) {
                    return "Prepar3D " + decimalFormat1.format((float)version / 10.0f);
                }
                if (version >= 101 && version <= 109) {
                    return "FSX Steam Edition, build: " + String.valueOf(62607 + (version - 100));
                }
                if (version >= 110) {
                    return "Microsoft Flight Simulator (2020)";
                }
                return "N/A";
            }
        }
        return new FSXP3DVersionRequest();
    }
}

