/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers;

import com.mouseviator.fsuipc.FSUIPC;
import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IWriteOnlyRequest;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacroHelper {
    public static final int PARAMETER_OFFSET = 3436;
    public static final int CONTROL_OFFSET = 3440;

    public MacroResult executeMacro(String macro) {
        return this.executeMacro(macro, 0);
    }

    public MacroResult executeMacro(String macro, FSUIPC fsuipc, boolean continual) {
        return this.executeMacro(macro, 0, fsuipc, continual);
    }

    public MacroResult executeMacro(String macro, int macroParam) {
        MacroResult result = null;
        MacroParamRequest paramRequest = new MacroParamRequest(macroParam);
        try {
            MacroExecuteRequest executeRequest = new MacroExecuteRequest(macro);
            result = new MacroResult(executeRequest, paramRequest);
        }
        catch (Exception ex) {
            Logger.getLogger(MacroHelper.class.getName()).log(Level.SEVERE, "Failed to create macro execute request!", ex);
        }
        return result;
    }

    public MacroResult executeMacro(String macro, int macroParam, FSUIPC fsuipc, boolean continual) {
        MacroResult result = null;
        if (fsuipc == null) {
            return null;
        }
        MacroParamRequest paramRequest = new MacroParamRequest(macroParam);
        try {
            MacroExecuteRequest executeRequest = new MacroExecuteRequest(macro);
            result = new MacroResult(executeRequest, paramRequest);
            if (continual) {
                fsuipc.addContinualRequest(result.paramRequest);
                fsuipc.addContinualRequest(result.macroExecuteRequest);
            } else {
                fsuipc.addOneTimeRequest(result.paramRequest);
                fsuipc.addOneTimeRequest(result.macroExecuteRequest);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MacroHelper.class.getName()).log(Level.SEVERE, "Failed to create macro execute request!", ex);
        }
        return result;
    }

    public MacroResult executeMacro(String macroFile, String macroName) {
        return this.executeMacro(macroFile, macroName, 0);
    }

    public MacroResult executeMacro(String macroFile, String macroName, FSUIPC fsuipc, boolean continual) {
        return this.executeMacro(macroFile, macroName, 0, fsuipc, continual);
    }

    public MacroResult executeMacro(String macroFile, String macroName, int macroParam) {
        MacroResult result = null;
        MacroParamRequest paramRequest = new MacroParamRequest(macroParam);
        try {
            MacroExecuteRequest executeRequest = new MacroExecuteRequest(macroFile, macroName);
            result = new MacroResult(executeRequest, paramRequest);
        }
        catch (Exception ex) {
            Logger.getLogger(MacroHelper.class.getName()).log(Level.SEVERE, "Failed to create macro execute request!", ex);
        }
        return result;
    }

    public MacroResult executeMacro(String macroFile, String macroName, int macroParam, FSUIPC fsuipc, boolean continual) {
        MacroResult result = null;
        if (fsuipc == null) {
            return null;
        }
        MacroParamRequest paramRequest = new MacroParamRequest(macroParam);
        try {
            MacroExecuteRequest executeRequest = new MacroExecuteRequest(macroFile, macroName);
            result = new MacroResult(executeRequest, paramRequest);
            if (continual) {
                fsuipc.addContinualRequest(result.paramRequest);
                fsuipc.addContinualRequest(result.macroExecuteRequest);
            } else {
                fsuipc.addOneTimeRequest(result.paramRequest);
                fsuipc.addOneTimeRequest(result.macroExecuteRequest);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MacroHelper.class.getName()).log(Level.SEVERE, "Failed to create macro execute request!", ex);
        }
        return result;
    }

    public static class MacroResult {
        private MacroExecuteRequest macroExecuteRequest = null;
        private MacroParamRequest paramRequest = null;

        public MacroResult() {
        }

        public MacroResult(MacroExecuteRequest macroExecuteRequest, MacroParamRequest paramRequest) {
            this.macroExecuteRequest = macroExecuteRequest;
            this.paramRequest = paramRequest;
        }

        public MacroExecuteRequest getMacroExecuteRequest() {
            return this.macroExecuteRequest;
        }

        public void setMacroExecuteRequest(MacroExecuteRequest macroExecuteRequest) {
            this.macroExecuteRequest = macroExecuteRequest;
        }

        public MacroParamRequest getParamRequest() {
            return this.paramRequest;
        }

        public void setParamRequest(MacroParamRequest paramRequest) {
            this.paramRequest = paramRequest;
        }
    }

    public static class MacroParamRequest
    extends DataRequest
    implements IWriteOnlyRequest<Integer> {
        public MacroParamRequest(Integer value) {
            this.dataBuffer = new byte[4];
            this.offset = 3436;
            this.type = IDataRequest.RequestType.WRITE;
            this.putInt(value);
        }

        @Override
        public void setValue(Integer value) {
            this.putInt(value);
        }
    }

    public static class MacroExecuteRequest
    extends DataRequest
    implements IWriteOnlyRequest<String> {
        public static final char MACRO_SEPARATOR = ':';
        private static final byte MAX_MACRO_FILE_LENGHT = 16;
        private static final byte MAX_MACRO_NAME_LENGTH = 16;
        private Pattern macroValuePattern = Pattern.compile("(.{1,16}):(.{1,16})");
        private Charset charset = Charset.forName("UTF-8");

        public MacroExecuteRequest(String macro) throws InvalidParameterException {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.constructMacroString(macro);
        }

        public MacroExecuteRequest(String macro, Charset charset) throws InvalidParameterException {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            if (charset != null) {
                this.charset = charset;
            }
            this.constructMacroString(macro);
        }

        public MacroExecuteRequest(String macroFile, String macroName) throws InvalidParameterException {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.constructMacroString(macroFile, macroName);
        }

        public MacroExecuteRequest(String macroFile, String macroName, Charset charset) throws InvalidParameterException {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            if (charset != null) {
                this.charset = charset;
            }
            this.constructMacroString(macroFile, macroName);
        }

        @Override
        public void setValue(String value) {
            this.constructMacroString(value);
        }

        private void constructMacroString(String macro) throws InvalidParameterException {
            Matcher matcher = this.macroValuePattern.matcher(macro);
            if (!matcher.matches()) {
                throw new InvalidParameterException(MessageFormat.format("Failed to match given macro: {0} against macro regex: {1}", macro, this.macroValuePattern.toString()));
            }
            String[] macroParts = macro.split(Character.toString(':'));
            this.constructMacroString(macroParts[0], macroParts[1]);
        }

        private void constructMacroString(String macroFile, String macroName) {
            byte[] macroFileBytes = macroFile.getBytes(this.charset);
            if (macroFileBytes.length > 16) {
                throw new InvalidParameterException(MessageFormat.format("The length of the byte array of the converted macro file name is too long. It's length is: {0} and maximum is: {1}", macroFileBytes.length, (byte)16));
            }
            byte[] macroNameBytes = macroName.getBytes(this.charset);
            if (macroNameBytes.length > 16) {
                throw new InvalidParameterException(MessageFormat.format("The length of the byte array of the converted macro name is too long. It's length is: {0} and maximum is: {1}", macroNameBytes.length, (byte)16));
            }
            this.dataBuffer = new byte[macroFileBytes.length + macroNameBytes.length + 2];
            System.arraycopy(macroFileBytes, 0, this.dataBuffer, 0, macroFileBytes.length);
            this.dataBuffer[macroFileBytes.length] = 58;
            System.arraycopy(macroNameBytes, 0, this.dataBuffer, macroFileBytes.length + 1, macroNameBytes.length);
            this.dataBuffer[this.dataBuffer.length - 1] = 0;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }
    }
}

