/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.datarequest.primitives;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import java.security.InvalidParameterException;

public class LongRequest
extends DataRequest
implements IDataRequest<Long> {
    public LongRequest() {
        this.dataBuffer = new byte[8];
    }

    public LongRequest(int offset) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
    }

    public LongRequest(int offset, long value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.putLong(value);
        this.type = IDataRequest.RequestType.WRITE;
    }

    public LongRequest(int offset, Long value) throws InvalidParameterException {
        this();
        if (offset < 0 || offset > Integer.MAX_VALUE) {
            throw new InvalidParameterException("Offset value out of supported range!");
        }
        this.offset = offset;
        this.putLong(value);
        this.type = IDataRequest.RequestType.WRITE;
    }

    @Override
    public Long getValue() {
        return this.getLong();
    }

    @Override
    public void setValue(Long value) {
        this.putLong(value);
    }
}

