/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum ProjectProperties {
    INSTANCE;

    private static final String PROPERTIES_FILE = "project.properties";
    private static final String PROP_VERSION = "version";
    private static final String PROP_NAME = "name";
    private final Log log = LogFactory.getLog(ProjectProperties.class);
    private final Properties props = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectProperties() {
        this.log.debug((Object)"Loading project properties...");
        InputStream is = null;
        try {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            is = classloader.getResourceAsStream(PROPERTIES_FILE);
            this.props.load(is);
            this.log.debug((Object)"Properties successfully loaded.");
        }
        catch (IOException e) {
            this.log.warn((Object)"Unable to read project properties.", (Throwable)e);
            this.props.put(PROP_NAME, "JxMapViewer");
            this.props.put(PROP_VERSION, "1.0");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                this.log.warn((Object)"Unable to close stream.", (Throwable)e);
            }
        }
    }

    public String getVersion() {
        return this.props.getProperty(PROP_VERSION);
    }

    public String getName() {
        return this.props.getProperty(PROP_NAME);
    }
}

