/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers.avionics;

import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IWriteOnlyRequest;
import com.mouseviator.fsuipc.datarequest.primitives.FloatRequest;

public abstract class RadioHelper {
    protected int frequencyOffset;
    protected int standbyFrequencyOffset;
    protected byte frequencySwapValue;

    public FloatRequest getFrequency() {
        return new FloatRequest(this.frequencyOffset){
            {
                this.dataBuffer = new byte[2];
            }

            @Override
            public void setValue(Float value) {
                this.putShort(RadioHelper.this.encodeFrequency(value.floatValue()));
            }

            @Override
            public Float getValue() {
                return Float.valueOf(RadioHelper.this.decodeFrequency(this.getShort()));
            }
        };
    }

    public FloatRequest getStandByFrequency() {
        return new FloatRequest(this.standbyFrequencyOffset){
            {
                this.dataBuffer = new byte[2];
            }

            @Override
            public void setValue(Float value) {
                this.putShort(RadioHelper.this.encodeFrequency(value.floatValue()));
            }

            @Override
            public Float getValue() {
                return Float.valueOf(RadioHelper.this.decodeFrequency(this.getShort()));
            }
        };
    }

    public IDataRequest<Byte> swapFrequencies() {
        class SwapFreqiencyRequest
        extends DataRequest
        implements IWriteOnlyRequest<Byte> {
            SwapFreqiencyRequest() {
                this.offset = 12579;
                this.dataBuffer = new byte[1];
            }

            @Override
            public void setValue(Byte value) {
                this.dataBuffer[0] = RadioHelper.this.frequencySwapValue;
            }
        }
        return new SwapFreqiencyRequest();
    }

    private float decodeFrequency(short value) {
        float frequency = 100.0f;
        frequency += (float)(((value & 0xFF00) >> 12) * 10);
        frequency += (float)((value & 0xF00) >> 8);
        frequency += (float)((value & 0xF0) >> 4) / 10.0f;
        return frequency += (float)(value & 0xF) / 100.0f;
    }

    private short encodeFrequency(float frequency) {
        short freqValue = (short)Math.ceil((frequency - 100.0f) * 100.0f);
        short storeValue = 0;
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            short reminder = (short)(freqValue % 10);
            storeValue = (short)(storeValue + (reminder << i * 4));
            freqValue = (short)(freqValue / 10);
        }
        return storeValue;
    }
}

