/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.fsuipc.helpers;

import com.mouseviator.fsuipc.FSUIPC;
import com.mouseviator.fsuipc.datarequest.DataRequest;
import com.mouseviator.fsuipc.datarequest.IDataRequest;
import com.mouseviator.fsuipc.datarequest.IWriteOnlyRequest;
import com.mouseviator.fsuipc.helpers.MacroHelper;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LuaHelper {
    public static final int PARAMETER_OFFSET = 3436;
    public static final int CONTROL_OFFSET = 3440;

    public LuaResult luaRequest(String luaProgram, int luaParam, LuaControlRequestCommand luaCommand) {
        LuaResult result = null;
        LuaParamRequest paramRequest = new LuaParamRequest(luaParam);
        try {
            LuaControlRequest controlRequest = new LuaControlRequest(luaCommand, luaProgram);
            result = new LuaResult(controlRequest, paramRequest);
        }
        catch (Exception ex) {
            Logger.getLogger(MacroHelper.class.getName()).log(Level.SEVERE, "Failed to create Lua request!", ex);
        }
        return result;
    }

    public LuaResult luaRequest(String luaProgram, int luaParam, LuaControlRequestCommand luaCommand, FSUIPC fsuipc, boolean continual) {
        LuaResult result = null;
        if (fsuipc == null) {
            return null;
        }
        LuaParamRequest paramRequest = new LuaParamRequest(luaParam);
        try {
            LuaControlRequest controlRequest = new LuaControlRequest(luaCommand, luaProgram);
            result = new LuaResult(controlRequest, paramRequest);
            if (continual) {
                fsuipc.addContinualRequest(paramRequest);
                fsuipc.addContinualRequest(controlRequest);
            } else {
                fsuipc.addOneTimeRequest(paramRequest);
                fsuipc.addOneTimeRequest(controlRequest);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MacroHelper.class.getName()).log(Level.SEVERE, "Failed to create Lua request!", ex);
        }
        return result;
    }

    public LuaResult lua(String luaProgram) {
        return this.luaRequest(luaProgram, 0, LuaControlRequestCommand.LUA);
    }

    public LuaResult lua(String luaProgram, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, 0, LuaControlRequestCommand.LUA);
    }

    public LuaResult lua(String luaProgram, int luaParam) {
        return this.luaRequest(luaProgram, luaParam, LuaControlRequestCommand.LUA);
    }

    public LuaResult lua(String luaProgram, int luaParam, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, luaParam, LuaControlRequestCommand.LUA);
    }

    public LuaResult luaValue(String luaProgram, int luaParam) {
        return this.luaRequest(luaProgram, luaParam, LuaControlRequestCommand.LUA_VALUE);
    }

    public LuaResult luaValue(String luaProgram, int luaParam, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, luaParam, LuaControlRequestCommand.LUA_VALUE);
    }

    public LuaResult luaDebug(String luaProgram) {
        return this.luaRequest(luaProgram, 0, LuaControlRequestCommand.LUA_DEBUG);
    }

    public LuaResult luaDebug(String luaProgram, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, 0, LuaControlRequestCommand.LUA_DEBUG);
    }

    public LuaResult luaDebug(String luaProgram, int luaParam) {
        return this.luaRequest(luaProgram, luaParam, LuaControlRequestCommand.LUA_DEBUG);
    }

    public LuaResult luaDebug(String luaProgram, int luaParam, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, luaParam, LuaControlRequestCommand.LUA_DEBUG);
    }

    public LuaResult luaKill(String luaProgram) {
        return this.luaRequest(luaProgram, 0, LuaControlRequestCommand.LUA_KILL);
    }

    public LuaResult luaKill(String luaProgram, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, 0, LuaControlRequestCommand.LUA_KILL);
    }

    public IDataRequest luaKillAll() {
        class LuaKillAllRequest
        extends DataRequest
        implements IWriteOnlyRequest<Integer> {
            LuaKillAllRequest() {
                this.dataBuffer = new byte[4];
                this.putInt(1084);
                this.offset = 12560;
                this.type = IDataRequest.RequestType.WRITE;
            }

            @Override
            public void setValue(Integer value) {
                this.putInt(value);
            }
        }
        return new LuaKillAllRequest();
    }

    public LuaResult luaSet(String luaProgram, int luaFlag) {
        return this.luaRequest(luaProgram, luaFlag, LuaControlRequestCommand.LUA_SET);
    }

    public LuaResult luaSet(String luaProgram, int luaFlag, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, luaFlag, LuaControlRequestCommand.LUA_SET);
    }

    public LuaResult luaClear(String luaProgram, int luaFlag) {
        return this.luaRequest(luaProgram, luaFlag, LuaControlRequestCommand.LUA_CLEAR);
    }

    public LuaResult luaClear(String luaProgram, int luaFlag, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, luaFlag, LuaControlRequestCommand.LUA_CLEAR);
    }

    public LuaResult luaToggle(String luaProgram, int luaFlag) {
        return this.luaRequest(luaProgram, luaFlag, LuaControlRequestCommand.LUA_TOGGLE);
    }

    public LuaResult luaToggle(String luaProgram, int luaFlag, FSUIPC fsuipc) {
        return this.runLuaCommandOnce(fsuipc, luaProgram, luaFlag, LuaControlRequestCommand.LUA_TOGGLE);
    }

    private LuaResult runLuaCommandOnce(FSUIPC fsuipc, String luaProgram, int luaParam, LuaControlRequestCommand command) {
        if (fsuipc == null) {
            return null;
        }
        LuaResult result = this.luaRequest(luaProgram, luaParam, command);
        if (result != null) {
            fsuipc.addOneTimeRequest(result.getParamRequest());
            fsuipc.addOneTimeRequest(result.getControlRequest());
        }
        return result;
    }

    public static class LuaParamRequest
    extends DataRequest
    implements IWriteOnlyRequest<Integer> {
        public LuaParamRequest(Integer value) {
            this.dataBuffer = new byte[4];
            this.offset = 3436;
            this.type = IDataRequest.RequestType.WRITE;
            this.putInt(value);
        }

        @Override
        public void setValue(Integer value) {
            this.putInt(value);
        }
    }

    public static class LuaControlRequest
    extends DataRequest
    implements IWriteOnlyRequest<String> {
        public static final String COMMAND_SEPARATOR = ":";
        private LuaControlRequestCommand command;
        private Charset charset = Charset.forName("UTF-8");

        public LuaControlRequest(String luaProgram) throws InvalidParameterException {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.command = LuaControlRequestCommand.LUA;
            if (luaProgram == null || luaProgram.isBlank()) {
                throw new InvalidParameterException("The luapProgram cannot be null or blank!");
            }
            this.convertStringToByteArray(this.command.getValue() + COMMAND_SEPARATOR + luaProgram, 0, this.charset);
        }

        public LuaControlRequest(String luaProgram, Charset charset) throws InvalidParameterException {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.command = LuaControlRequestCommand.LUA;
            if (charset != null) {
                this.charset = charset;
            }
            if (luaProgram == null || luaProgram.isBlank()) {
                throw new InvalidParameterException("The luapProgram cannot be null or blank!");
            }
            this.convertStringToByteArray(this.command.getValue() + COMMAND_SEPARATOR + luaProgram, 0, charset);
        }

        public LuaControlRequest(LuaControlRequestCommand command, String luaProgram) throws InvalidParameterException {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.command = LuaControlRequestCommand.LUA;
            this.command = command;
            if (luaProgram == null || luaProgram.isBlank()) {
                throw new InvalidParameterException("The luapProgram cannot be null or blank!");
            }
            this.convertStringToByteArray(this.command.getValue() + COMMAND_SEPARATOR + luaProgram, 0, this.charset);
        }

        public LuaControlRequest(LuaControlRequestCommand command, String luaProgram, Charset charset) throws InvalidParameterException {
            this.offset = 3440;
            this.type = IDataRequest.RequestType.WRITE;
            this.command = LuaControlRequestCommand.LUA;
            if (charset != null) {
                this.charset = charset;
            }
            this.command = command;
            if (luaProgram == null || luaProgram.isBlank()) {
                throw new InvalidParameterException("The luapProgram cannot be null or blank!");
            }
            this.convertStringToByteArray(this.command.getValue() + COMMAND_SEPARATOR + luaProgram, 0, charset);
        }

        @Override
        public void setValue(String value) {
            if (value != null && !value.isBlank()) {
                this.convertStringToByteArray(this.command.getValue() + COMMAND_SEPARATOR + value, 0, this.charset);
            }
        }

        public LuaControlRequestCommand getCommand() {
            return this.command;
        }

        public void setCommand(LuaControlRequestCommand command) {
            String currValue = new String(this.dataBuffer, this.charset).trim();
            String luaProgram = currValue.replace(this.command.getValue(), "").replace(COMMAND_SEPARATOR, "").trim();
            this.command = command;
            this.convertStringToByteArray(this.command.getValue() + COMMAND_SEPARATOR + luaProgram, 0, this.charset);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }
    }

    public static enum LuaControlRequestCommand {
        LUA("Lua"),
        LUA_VALUE("LuaValue"),
        LUA_DEBUG("LuaDebug"),
        LUA_KILL("LuaKill"),
        LUA_SET("LuaSet"),
        LUA_CLEAR("LuaClear"),
        LUA_TOGGLE("LuaToggle");

        private final String value;
        private static final Map<String, LuaControlRequestCommand> lookupTable;

        private LuaControlRequestCommand(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static LuaControlRequestCommand get(String value) throws InvalidParameterException {
            if (!lookupTable.containsKey(value)) {
                throw new InvalidParameterException("Command value: " + value + " NOT supported!");
            }
            return lookupTable.get(value);
        }

        static {
            lookupTable = new HashMap<String, LuaControlRequestCommand>();
            for (LuaControlRequestCommand type : EnumSet.allOf(LuaControlRequestCommand.class)) {
                lookupTable.put(type.getValue(), type);
            }
        }
    }

    public static class LuaResult {
        private LuaControlRequest controlRequest = null;
        private LuaParamRequest paramRequest = null;

        public LuaResult() {
        }

        public LuaResult(LuaControlRequest controlRequest, LuaParamRequest paramRequest) {
            this.controlRequest = controlRequest;
            this.paramRequest = paramRequest;
        }

        public LuaParamRequest getParamRequest() {
            return this.paramRequest;
        }

        public void setParamRequest(LuaParamRequest paramRequest) {
            this.paramRequest = paramRequest;
        }

        public LuaControlRequest getControlRequest() {
            return this.controlRequest;
        }

        public void setControlRequest(LuaControlRequest controlRequest) {
            this.controlRequest = controlRequest;
        }
    }
}

