//Make sure replaceAll function exists
if (typeof String.prototype.replaceAll == "undefined") {
    String.prototype.replaceAll = function (match, replace) {
        return this.replace(new RegExp(match, 'g'), () => replace);
    };
}

/* 
 * A helper class to convert logbook data to CSV format
 * 
 */
class CSVHelper {
    /**
     * A function to convert logbook data into CSV string.
     * 
     * @param {type} logbook
     * @returns {result|String}
     */
    static logbookToCSV(logbook) {
        if (logbook.entries) {
            //preapre result, first line is header line
            let result = "Day;Month;Year;Date;logVersion;entryID;creationTimeInSeconds;startDay;startMonth;startYear;startTimeInSeconds;totalHours;nightHours;dayHours;ifrHours;vfrHours;dayLandingCount;dayTakeOffCount;nightLandingCount;nightTakeOffCount;startingAirport;endingAirport;fullFlight;aircraftCategory;aircraftID;aircraftName;activityName;notes;distanceValue;distanceUnit\n";

            try {
                for (var i = 0; i < logbook.entries.length; i++) {
                    let tl_entry = logbook.entries[i];

                    //process all flights in the entry
                    for (var j = 0; j < tl_entry.daFlights.length; j++) {
                        let flight_entry = tl_entry.daFlights[j];

                        //build the CSV line
                        let line = tl_entry.iDay + ";" + tl_entry.iMonth + ";" + tl_entry.iYear + ";";
                        line += "\"" + tl_entry.sDate.replaceAll("\n", "\\n") + "\";";
                        line += flight_entry.iLogVersion + ";" + flight_entry.entryID + ";" + flight_entry.iCreationTimeInSeconds + ";" + flight_entry.iStartDay + ";" + flight_entry.iStartMonth + ";"
                                + flight_entry.iStartYear + ";" + flight_entry.iStartTimeInSeconds + ";" + flight_entry.fTotalHours + ";" + flight_entry.fNightHours + ";"
                                + flight_entry.fDayHours + ";" + flight_entry.fIFRHours + ";" + flight_entry.fVFRHours + ";" + flight_entry.iDayLandingCount + ";"
                                + flight_entry.iDayTakeOffCount + ";" + flight_entry.iNightLandingCount + ";" + flight_entry.iNightTakeOffCount + ";";
                        line += "\"" + flight_entry.sStartingAirport.replaceAll("\n", "\\n") + "\";";
                        line += "\"" + flight_entry.sEndingAirport.replaceAll("\n", "\\n") + "\";";
                        line += flight_entry.bFullFlight + ";"
                        line += "\"" + flight_entry.sAircraftCategory.replaceAll("\n", "\\n") + "\";";
                        line += "\"" + flight_entry.sAircraftId.replaceAll("\n", "\\n") + "\";";
                        line += "\"" + flight_entry.sAircraftName.replaceAll("\n", "\\n") + "\";";
                        line += "\"" + flight_entry.sActivityName.replaceAll("\n", "\\n") + "\";";

                        for (var k = 0; k < flight_entry.daNotes.length; k++) {
                            if (k >= 1) {       //add \\n if more than one note is present
                                line += "\\n";
                            }
                            line += flight_entry.daNotes[k];                            
                        }
                        line += ";";
                        line += flight_entry.distance.value + ";" + flight_entry.distance.unit + ";\n";

                        //add line to result
                        result += line;
                    }
                }
            } catch (err) {
                console.error("There was an error converting logbook to CSV, message: " + err.message);
            }

            //return what we have, even if exception was thrown
            return result;
        }

        return "";
    }
}